/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Entity_EE.h: interface for the Entity_EE class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_EE_H
#define ENTITY_EE_H


#include "Entity.h"
#include "Entity_EE_ASN1.h"
#include "EeStore.h"

/*!
	This class represents an EE Entity
*/
class Entity_EE : public Entity  
{
public:
	void PrintInfo(FILE * out);
	Entity_EE(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_EE();
	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);

	bool Responder_ValidateRequest(const NewpkiRequest & Request, const X509_PUBKEY * Requester, mString & SenderName);
	bool Responder_TreatRequestAsynch(const NewpkiRequest & Request, const Asn1OctetString & transactionId, const mString & SenderName);
	bool Requester_OnNewResponse(const Asn1OctetString & transactionID, const X509_PUBKEY * sender, const NewpkiResponse & Response);
	

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);
private:
	bool ValidateDn(COMMAND_PARAMETERS);
	bool GetValidateDn(COMMAND_PARAMETERS);
	bool GetLocalConf(COMMAND_PARAMETERS);
	bool WebUserCreate(COMMAND_PARAMETERS);
	bool WebUserLogin(COMMAND_PARAMETERS);
	bool WebUserActivate(COMMAND_PARAMETERS);
	bool WebUserEnumCerts(COMMAND_PARAMETERS);
	bool WebUserRequestCert(COMMAND_PARAMETERS);
	bool WebUserGetDn(COMMAND_PARAMETERS);
	bool WebUserRevokeCert(COMMAND_PARAMETERS);
	bool WebUserChangePassword(COMMAND_PARAMETERS);
	bool EnumProfiles(COMMAND_PARAMETERS);
	bool DeletePkcs12(COMMAND_PARAMETERS);
	bool WebUserSendDnToRa(unsigned long user_id);


		
	bool PrepareConfToWrite();
	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);
	bool ProceedWithRequest(const NewpkiRequest & req, const Asn1OctetString & transactionId, LOG_MESSAGE_TYPE & LogType, mString & ObjectName, mString & Err);
	

	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);

	bool ParseNewConf();
	
	LocalEeConf myConf;
	HashTable_String m_Policies;

	EeStore lStore;

	static void ThreadNotifyUsers(const NewpkiThread * Thread, void * param);
	NewpkiThread hThreadNotifyUsers;

	DECLARE_COMMAND_PARSER(Entity_EE);
};

#endif
