/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Entity_PUBLICATION_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(LOCAL_PUBLICATION_CONF) = {
	ASN1_SIMPLE(LOCAL_PUBLICATION_CONF, conf, ENTITY_CONF),
	ASN1_SIMPLE(LOCAL_PUBLICATION_CONF, cas, INTERNAL_PKI_CA),
	ASN1_SEQUENCE_OF(LOCAL_PUBLICATION_CONF, known_cas, X509),
}ASN1_SEQUENCE_END(LOCAL_PUBLICATION_CONF)
ASN1_SEQUENCE(LOCAL_PUBLICATION_CONF_BETA4) = {
	ASN1_SIMPLE(LOCAL_PUBLICATION_CONF_BETA4, conf, ENTITY_CONF_BETA4),
	ASN1_SIMPLE(LOCAL_PUBLICATION_CONF_BETA4, cas, INTERNAL_PKI_CA),
	ASN1_SEQUENCE_OF(LOCAL_PUBLICATION_CONF_BETA4, known_cas, X509),
}ASN1_SEQUENCE_END(LOCAL_PUBLICATION_CONF_BETA4)
LocalPublicationConf LocalPublicationConf::EmptyInstance;
bool LocalPublicationConf::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalPublicationConf::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalPublicationConf::get_cas()
{
	return m_cas;
}

bool LocalPublicationConf::set_conf(const EntityConf & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConf & LocalPublicationConf::get_conf() const
{
	return m_conf;
}

EntityConf & LocalPublicationConf::get_conf()
{
	return m_conf;
}

bool LocalPublicationConf::set_knownCas(const mVector< PKI_CERT > & c_knownCas)
{
	m_knownCas = c_knownCas;
	return true;
}

const mVector< PKI_CERT > & LocalPublicationConf::get_knownCas() const
{
	return m_knownCas;
}

mVector< PKI_CERT > & LocalPublicationConf::get_knownCas()
{
	return m_knownCas;
}

bool LocalPublicationConf::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_PUBLICATION_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalPublicationConf::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_PUBLICATION_CONF * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalPublicationConf::LocalPublicationConf():NewPKIObject(), LocalEntityConf()
{
	resetAll();
}

LocalPublicationConf::LocalPublicationConf(const LocalPublicationConf & other):NewPKIObject(), LocalEntityConf()
{
	resetAll();
	*this = other;
}

LocalPublicationConf::~LocalPublicationConf()
{
	Clear();
}

void LocalPublicationConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalPublicationConf::freeAll()
{
}

void LocalPublicationConf::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
	m_knownCas.clear();
}

bool LocalPublicationConf::load_Datas(const LOCAL_PUBLICATION_CONF * Datas)
{
	Clear();
	int i;
	X509 * currknownCas;
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->known_cas)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->known_cas); i++)
		{
			currknownCas = SKM_sk_value(X509, Datas->known_cas, i);
			if(!currknownCas)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_knownCas.insert(m_knownCas.begin() + i);
			if(!m_knownCas[i].load_Datas(currknownCas))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool LocalPublicationConf::give_Datas(LOCAL_PUBLICATION_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_PUBLICATION_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	X509 * currknownCas;
	size_t i;
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->known_cas && !((*Datas)->known_cas = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_knownCas.size() ; i++)
	{
		currknownCas = NULL;
		if(!m_knownCas[i].give_Datas(&currknownCas))
		{
			ASN1_item_free((ASN1_VALUE*)currknownCas, ASN1_ITEM_rptr(X509));
			currknownCas = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->known_cas, currknownCas) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currknownCas, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool LocalPublicationConf::operator=(const LocalPublicationConf & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_knownCas = other.m_knownCas;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalPublicationConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_PUBLICATION_CONF);
}
LocalPublicationConfBeta4 LocalPublicationConfBeta4::EmptyInstance;
bool LocalPublicationConfBeta4::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalPublicationConfBeta4::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalPublicationConfBeta4::get_cas()
{
	return m_cas;
}

bool LocalPublicationConfBeta4::set_conf(const EntityConfBeta4 & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConfBeta4 & LocalPublicationConfBeta4::get_conf() const
{
	return m_conf;
}

EntityConfBeta4 & LocalPublicationConfBeta4::get_conf()
{
	return m_conf;
}

bool LocalPublicationConfBeta4::set_knownCas(const mVector< PKI_CERT > & c_knownCas)
{
	m_knownCas = c_knownCas;
	return true;
}

const mVector< PKI_CERT > & LocalPublicationConfBeta4::get_knownCas() const
{
	return m_knownCas;
}

mVector< PKI_CERT > & LocalPublicationConfBeta4::get_knownCas()
{
	return m_knownCas;
}

bool LocalPublicationConfBeta4::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_PUBLICATION_CONF_BETA4 * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalPublicationConfBeta4::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_PUBLICATION_CONF_BETA4 * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalPublicationConfBeta4::LocalPublicationConfBeta4():NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
}

LocalPublicationConfBeta4::LocalPublicationConfBeta4(const LocalPublicationConfBeta4 & other):NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
	*this = other;
}

LocalPublicationConfBeta4::~LocalPublicationConfBeta4()
{
	Clear();
}

void LocalPublicationConfBeta4::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalPublicationConfBeta4::freeAll()
{
}

void LocalPublicationConfBeta4::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
	m_knownCas.clear();
}

bool LocalPublicationConfBeta4::load_Datas(const LOCAL_PUBLICATION_CONF_BETA4 * Datas)
{
	Clear();
	int i;
	X509 * currknownCas;
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->known_cas)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->known_cas); i++)
		{
			currknownCas = SKM_sk_value(X509, Datas->known_cas, i);
			if(!currknownCas)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_knownCas.insert(m_knownCas.begin() + i);
			if(!m_knownCas[i].load_Datas(currknownCas))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool LocalPublicationConfBeta4::give_Datas(LOCAL_PUBLICATION_CONF_BETA4 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_PUBLICATION_CONF_BETA4*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	X509 * currknownCas;
	size_t i;
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF_BETA4*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BETA4))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF_BETA4));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->known_cas && !((*Datas)->known_cas = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_knownCas.size() ; i++)
	{
		currknownCas = NULL;
		if(!m_knownCas[i].give_Datas(&currknownCas))
		{
			ASN1_item_free((ASN1_VALUE*)currknownCas, ASN1_ITEM_rptr(X509));
			currknownCas = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->known_cas, currknownCas) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currknownCas, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool LocalPublicationConfBeta4::operator=(const LocalPublicationConfBeta4 & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_knownCas = other.m_knownCas;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalPublicationConfBeta4::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_PUBLICATION_CONF_BETA4);
}
