/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.Compilation;
import bossa.modules.Content;
import bossa.syntax.AST;
import bossa.syntax.Definition;
import bossa.syntax.LocatedString;
import bossa.syntax.Module;
import bossa.syntax.Node;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Declaration;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import mlsub.typing.Typing;
import nice.tools.code.Import;
import nice.tools.code.NiceInterpreter;
import nice.tools.code.SpecialTypes;
import nice.tools.code.Strings;
import nice.tools.code.Types;
import nice.tools.typing.PrimitiveType;

public class Package
implements mlsub.compilation.Module,
Located,
Module {
    private String[] opens;
    private List imports;
    private List importedPackages;
    private static float PROGRESS_SCOPE = 0.04f;
    private static float PROGRESS_LOAD = 0.04f;
    private static float PROGRESS_TYPED_RESOLVE = 0.04f;
    private static float PROGRESS_LOCAL_RESOLVE = 0.04f;
    private static float PROGRESS_TYPECHECK = 0.5f;
    private static float PROGRESS_GENERATE_CODE = 0.1f;
    private static float PROGRESS_SAVE_INTERFACE = 0.04f;
    private static float PROGRESS_LINK = 0.2f;
    private boolean scoped = false;
    private static boolean contextFrozen;
    private boolean addedToArchive;
    static final String packageClassName = "fun";
    private gnu.expr.Package thisPkg;
    private ClassExp implementationClass;
    private ClassExp dispatchClass;
    public LocatedString name;
    private boolean isRoot;
    private List definitions;
    private AST ast;
    private Content source;
    Compilation compilation;
    public static Compilation currentCompilation;

    public static Package make(String name, Compilation compilation, boolean isRoot) {
        return Package.make(new LocatedString(name, Location.option), compilation, isRoot);
    }

    public static Package make(LocatedString lname, Compilation compilation, boolean isRoot) {
        String name = lname.toString();
        Package res = (Package)compilation.packages.get(name);
        if (res != null) {
            return res;
        }
        return new Package(lname, compilation, isRoot);
    }

    private Package(LocatedString name, Compilation compilation, boolean isRoot) {
        this.name = name;
        this.compilation = compilation;
        this.isRoot = isRoot;
        compilation.packages.put(name.toString(), this);
        this.source = compilation.locator.find(this);
        if (this.source == null) {
            User.error((Located)name, "Could not find package " + name);
        }
        boolean shouldReload = compilation.recompileAll || isRoot && compilation.recompileCommandLine;
        this.loadImports(shouldReload);
        this.prepareCodeGeneration();
        this.read(shouldReload);
    }

    private void loadImports(boolean shouldReload) {
        TreeSet<String> opens = new TreeSet<String>();
        opens.add("java.lang");
        opens.add("java.util");
        this.imports = this.source.getImports(opens, shouldReload);
        if (!this.name.toString().equals("nice.lang") && !Debug.ignorePrelude) {
            this.imports.add(new LocatedString("nice.lang", Location.nowhere()));
        }
        this.setOpens(opens);
        List p = this.getImports();
        Iterator i = p.iterator();
        while (i.hasNext()) {
            this.source.someImportModified(((Package)i.next()).lastModification());
        }
    }

    private void read(boolean shouldReload) {
        Module oldModule = Definition.currentModule;
        Definition.currentModule = this;
        Node.setModule(this);
        this.compilation.progress(this, "parsing");
        this.definitions = new ArrayList();
        this.source.getDefinitions(this.definitions, shouldReload);
        this.ast = dispatch.createAST(this, this.definitions);
        this.definitions = null;
        this.compilation.addNumberOfDeclarations(this.ast.numberOfDeclarations());
        if (this.compiling()) {
            this.compilation.recompilationNeeded = true;
        }
        Definition.currentModule = oldModule;
    }

    void setOpens(Set opens) {
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            opens.add(((LocatedString)i.next()).toString());
        }
        int len = opens.size();
        this.opens = opens.toArray(new String[len + 1]);
        this.opens[len] = this.opens[0];
        this.opens[0] = this.name.toString();
    }

    public long lastModification() {
        return this.source.lastModification;
    }

    private void readAlternatives() {
        for (Method method = this.source.getBytecode().getMethods(); method != null; method = method.getNext()) {
            dispatch.readImportedAlternative(this.source.getBytecode(), method, this.location());
        }
    }

    public List getRequirements() {
        return this.getImports();
    }

    public String[] listImplicitPackages() {
        return this.opens;
    }

    private List getImports() {
        if (this.importedPackages == null) {
            this.computeImportedPackages();
        }
        return this.importedPackages;
    }

    private void computeImportedPackages() {
        this.importedPackages = new ArrayList(this.imports.size());
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            LocatedString s = (LocatedString)i.next();
            this.importedPackages.add(Package.make(s, this.compilation, false));
        }
    }

    void addProgress(float weight) {
        this.compilation.addProgress(weight * (float)this.ast.numberOfDeclarations());
    }

    void addGlobalProgress(float weight) {
        this.compilation.addProgress(weight * (float)this.compilation.getNumberOfDeclarations());
    }

    public void scope() {
        if (this.scoped) {
            return;
        }
        this.scoped = true;
        this.ast.buildScope();
        this.addProgress(PROGRESS_SCOPE);
    }

    public void load() {
        this.ast.resolveScoping();
        if (!this.compiling()) {
            this.readAlternatives();
        }
        this.addProgress(PROGRESS_LOAD);
    }

    public void typedResolve() {
        this.ast.typedResolve();
        this.addProgress(PROGRESS_TYPED_RESOLVE);
    }

    public void localResolve() {
        this.ast.localResolve();
        this.addProgress(PROGRESS_LOCAL_RESOLVE);
    }

    public void compile() {
        this.compilation.exitIfErrors();
        this.generateCode();
        this.addProgress(PROGRESS_GENERATE_CODE);
        this.saveInterface();
        this.addProgress(PROGRESS_SAVE_INTERFACE);
    }

    public static void startNewCompilation() {
        Typing.startNewCompilation();
        Types.reset();
        SpecialTypes.init();
        dispatch.resetAlternatives();
        dispatch.resetDispatchTest();
        dispatch.resetTypeDefinitionMappings();
        dispatch.resetConstructorsMap();
        dispatch.resetJavaClasses();
        PrimitiveType.reset();
        Type.reset();
    }

    public void freezeGlobalContext() {
        contextFrozen = true;
        Typing.createInitialContext();
    }

    public void unfreezeGlobalContext() {
        contextFrozen = false;
        Typing.releaseInitialContext();
    }

    public static boolean contextFrozen() {
        return contextFrozen;
    }

    public void typecheck() {
        if (this.compiling()) {
            this.compilation.progress(this, "typechecking");
        }
        this.ast.typechecking(this.compiling());
        this.addProgress(PROGRESS_TYPECHECK);
    }

    public void link() {
        if (!this.isRoot) {
            return;
        }
        if (this.compiling()) {
            this.compilation.progress(this, "linking");
            dispatch.testCoverage(this);
            this.finishCompilation();
            this.compilation.exitIfErrors();
        }
        this.addGlobalProgress(PROGRESS_LINK);
        this.writeArchive();
        this.compilation.locator.save();
    }

    private void finishCompilation() {
        gnu.expr.Package pkg = this.compilePackages(null);
        try {
            pkg.compileToFiles();
            pkg = null;
        }
        catch (IOException e) {
            User.error((Located)this.name, "Error during creation of bytecode files:\n" + e);
        }
    }

    private gnu.expr.Package compilePackages(gnu.expr.Package res) {
        if (this.dispatchClass == null) {
            return res;
        }
        if (this.compiling()) {
            this.getImplementationClass();
        }
        if (this.implementationClass != null) {
            this.thisPkg.addClass(this.implementationClass);
        }
        this.thisPkg.addClass(this.dispatchClass);
        this.thisPkg.directory = this.source.getOutputDirectory();
        this.implementationClass = null;
        this.dispatchClass = null;
        this.thisPkg.next = res;
        res = this.thisPkg;
        this.thisPkg = null;
        this.ast = null;
        Iterator i = this.getImports().iterator();
        while (i.hasNext()) {
            res = ((Package)i.next()).compilePackages(res);
        }
        return res;
    }

    private void saveInterface() {
        if (!this.compiling()) {
            return;
        }
        File dir = this.source.getOutputDirectory();
        try {
            PrintWriter f = new PrintWriter(new BufferedWriter(new FileWriter(new File(dir, "package.nicei"))));
            f.print("package " + this.name + ";\n\n");
            Iterator i = this.getImports().iterator();
            while (i.hasNext()) {
                Package m = (Package)i.next();
                f.print("import " + m.getName() + ";\n");
            }
            f.println();
            for (int i2 = 0; i2 < this.opens.length; ++i2) {
                f.print("import " + this.opens[i2] + ".*" + (Import.isStrictPackage(this.opens[i2]) ? "(!)" : "") + ";\n");
            }
            f.println();
            this.ast.printInterface(f);
            f.close();
        }
        catch (IOException e) {
            User.warning(this.name, "Could not save the interface of package " + this.name);
        }
    }

    private void writeArchive() {
        if (this.compilation.output == null) {
            return;
        }
        File jarFile = this.createJarFile();
        try {
            JarOutputStream jarStream = this.createJarStream(jarFile);
            if (!this.compilation.excludeRuntime) {
                Package.writeRuntime(this.compilation.runtimeFile, jarStream);
            }
            this.addToArchive(jarStream, this.compiling());
            jarStream.close();
        }
        catch (Exception e) {
            jarFile.delete();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            User.error((Located)this, "Error while writing archive (" + e.getMessage() + ")", e);
        }
    }

    private File createJarFile() {
        File jarFile;
        File parent;
        if (!this.compilation.output.endsWith(".jar")) {
            this.compilation.output = this.compilation.output + ".jar";
        }
        if ((parent = (jarFile = new File(this.compilation.output)).getParentFile()) != null) {
            parent.mkdirs();
        }
        return jarFile;
    }

    private JarOutputStream createJarStream(File jarFile) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.name + ".dispatch");
        return new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
    }

    private static void writeRuntime(String runtimeJar, JarOutputStream jarStream) throws IOException {
        JarFile runtime = null;
        if (runtimeJar != null) {
            try {
                runtime = new JarFile(runtimeJar);
            }
            catch (ZipException e) {
                // empty catch block
            }
        }
        if (runtime == null) {
            Internal.warning("Runtime was not found. The archive is not self-contained");
            return;
        }
        String[] classes = new String[]{"gnu/mapping/Procedure.class", "gnu/mapping/Procedure0.class", "gnu/mapping/Procedure1.class", "gnu/mapping/Procedure2.class", "gnu/mapping/Procedure3.class", "gnu/mapping/ProcedureN.class", "gnu/mapping/Named.class", "gnu/mapping/Printable.class", "gnu/mapping/WrongArguments.class", "gnu/mapping/WrongType.class", "gnu/mapping/WrappedException.class", "gnu/expr/ModuleBody.class", "gnu/expr/ModuleMethod.class"};
        for (int i = 0; i < classes.length; ++i) {
            JarEntry entry = runtime.getJarEntry(classes[i]);
            if (entry == null) {
                System.out.println("Runtime: " + classes[i] + " not found");
                continue;
            }
            Package.addEntry(classes[i], runtime.getInputStream(entry), jarStream);
        }
    }

    private void addToArchive(JarOutputStream jarStream, boolean linkPerformed) throws IOException {
        if (this.addedToArchive) {
            return;
        }
        this.addedToArchive = true;
        this.compilation.progress(this, "writing in archive");
        String packagePrefix = this.getName().replace('.', '/') + "/";
        Content.Stream[] classes = this.source.getClasses(linkPerformed);
        for (int i = 0; i < classes.length; ++i) {
            Package.addEntry(packagePrefix + classes[i].name, classes[i].stream, jarStream);
        }
        Iterator i = this.getImports().iterator();
        while (i.hasNext()) {
            ((Package)i.next()).addToArchive(jarStream, linkPerformed);
        }
    }

    private static void addEntry(String name, InputStream data, JarOutputStream out) throws IOException {
        out.putNextEntry(new JarEntry(name));
        Package.copy(data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        int size = in.available();
        if (size < 1024) {
            size = 1024;
        }
        byte[] buf = new byte[size];
        try {
            int read;
            do {
                if ((read = in.read(buf)) <= 0) continue;
                out.write(buf, 0, read);
            } while (read != -1);
        }
        finally {
            in.close();
        }
    }

    public ClassExp getClassExp(Object def) {
        if (this.compiling()) {
            return dispatch.NiceClass_createClassExp(def);
        }
        String name = dispatch.NiceClass_getName(def).toString();
        ClassType classe = this.source.readClass(name);
        if (classe == null) {
            Internal.error("Compiled class " + def + " was not found");
        }
        this.importMethods(def, classe);
        ClassExp res = new ClassExp(classe);
        this.addUserClass(res);
        return res;
    }

    private void importMethods(Object def, ClassType classe) {
        for (Method method = classe.getMethods(); method != null; method = method.getNext()) {
            Definition d = dispatch.NiceClass_importMethod(def, method);
            if (d == null) continue;
            this.definitions.add(d);
        }
    }

    public void addUserClass(ClassExp classe) {
        this.thisPkg.addClass(classe);
        if (this.compiling()) {
            classe.outer = this.getImplementationClass();
        }
    }

    public void addGlobalVar(Declaration decl, boolean constant) {
        if (!this.compiling()) {
            decl.setSimple(false);
            decl.field = this.source.getBytecode().getField(decl.getName());
            if (decl.field == null) {
                Internal.error(this, "The compiled file is not consistant with the interface file for global variable " + decl.getName());
            }
        } else {
            this.getImplementationClass().addDeclaration(decl);
            if (constant) {
                decl.setFlag(16384);
            }
            decl.setFlag(10240);
        }
    }

    private ClassExp createClassExp(String name) {
        ClassExp res = new ClassExp();
        res.setName(name);
        res.setSimple(true);
        res.body = QuoteExp.voidExp;
        res.needsConstructor = true;
        return res;
    }

    public static String className(String name) {
        return name;
    }

    private void prepareCodeGeneration() {
        this.thisPkg = new gnu.expr.Package(this.getName());
        this.dispatchClass = this.createClassExp(this.name + ".dispatch");
        this.dispatchClass.addBytecodeAttribute(MiscAttr.synthetic());
    }

    private ClassExp getImplementationClass() {
        if (this.implementationClass == null) {
            this.implementationClass = this.createClassExp(this.name + "." + packageClassName);
        }
        return this.implementationClass;
    }

    private void generateCode() {
        if (this.compiling()) {
            this.compilation.progress(this, "generating code");
        }
        this.ast.compile(this.compiling());
    }

    public ClassType createClass(String name) {
        ClassType res;
        String className = this.name + "." + name;
        try {
            res = ClassType.make(className);
        }
        catch (LinkageError e) {
            res = new ClassType(className);
        }
        res.setExisting(false);
        return res;
    }

    public Method lookupDispatchClassMethod(String name, String attribute, String value) {
        return this.lookupClassMethod(this.source.getDispatch(), name, attribute, value);
    }

    private Method lookupClassMethod(ClassType clas, String name, String attribute, String value) {
        if (clas == null) {
            return null;
        }
        name = Strings.escape(name);
        for (Method m = clas.getDeclaredMethods(); m != null; m = m.getNext()) {
            MiscAttr attr;
            if (!m.getName().equals(name) && (!m.getName().startsWith(name) || m.getName().charAt(name.length()) != '$' || m.getName().charAt(name.length() + 1) == '$') || (attr = (MiscAttr)Attribute.get(m, attribute)) == null || !new String(attr.data).equals(value)) continue;
            return m;
        }
        return null;
    }

    public ReferenceExp addMethod(LambdaExp method, boolean packageMethod) {
        ClassExp classe = packageMethod ? this.getImplementationClass() : this.dispatchClass;
        return classe.addMethod(method);
    }

    public String bytecodeName() {
        return this.name.toString();
    }

    public Location location() {
        return this.name.location();
    }

    public String getName() {
        return this.name.toString();
    }

    public String toString() {
        return "package " + this.name;
    }

    public AST getDefinitions() {
        return this.ast;
    }

    public Compilation compilation() {
        return this.compilation;
    }

    public boolean interfaceFile() {
        return !this.compiling();
    }

    public boolean compiling() {
        return this.source.sourceRead;
    }

    static {
        NiceInterpreter.init();
    }
}

