/*
 * Decompiled with CFR 0.152.
 */
package nice.lang;

import java.lang.reflect.Array;
import java.util.AbstractList;
import nice.lang.rawBooleanArray;
import nice.lang.rawByteArray;
import nice.lang.rawCharArray;
import nice.lang.rawDoubleArray;
import nice.lang.rawFloatArray;
import nice.lang.rawIntArray;
import nice.lang.rawLongArray;
import nice.lang.rawObjectArray;
import nice.lang.rawShortArray;

public class rawArray
extends AbstractList {
    public final Object value;

    protected rawArray(Object value) {
        this.value = value;
    }

    public Object value() {
        return this.value;
    }

    public static rawArray make(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return new rawObjectArray((Object[])value);
        }
        if (value instanceof int[]) {
            return new rawIntArray((int[])value);
        }
        if (value instanceof byte[]) {
            return new rawByteArray((byte[])value);
        }
        if (value instanceof long[]) {
            return new rawLongArray((long[])value);
        }
        if (value instanceof char[]) {
            return new rawCharArray((char[])value);
        }
        if (value instanceof boolean[]) {
            return new rawBooleanArray((boolean[])value);
        }
        if (value instanceof double[]) {
            return new rawDoubleArray((double[])value);
        }
        if (value instanceof float[]) {
            return new rawFloatArray((float[])value);
        }
        if (value instanceof short[]) {
            return new rawShortArray((short[])value);
        }
        return new rawArray(value);
    }

    public int size() {
        return Array.getLength(this.value);
    }

    public Object get(int index) {
        return Array.get(this.value, index);
    }

    public Object set(int index, Object element) {
        Object res = this.get(index);
        rawArray.Array_set(this.value, index, element);
        return res;
    }

    public static boolean[] convert_boolean(Object[] array) {
        if (array == null) {
            return null;
        }
        boolean[] res = new boolean[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = (Boolean)o;
        }
        return res;
    }

    public static char[] convert_char(Object[] array) {
        if (array == null) {
            return null;
        }
        char[] res = new char[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Character)o).charValue();
        }
        return res;
    }

    public static byte[] convert_byte(Object[] array) {
        if (array == null) {
            return null;
        }
        byte[] res = new byte[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).byteValue();
        }
        return res;
    }

    public static short[] convert_short(Object[] array) {
        if (array == null) {
            return null;
        }
        short[] res = new short[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).shortValue();
        }
        return res;
    }

    public static int[] convert_int(Object[] array) {
        if (array == null) {
            return null;
        }
        int[] res = new int[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).intValue();
        }
        return res;
    }

    public static long[] convert_long(Object[] array) {
        if (array == null) {
            return null;
        }
        long[] res = new long[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).longValue();
        }
        return res;
    }

    public static float[] convert_float(Object[] array) {
        if (array == null) {
            return null;
        }
        float[] res = new float[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).floatValue();
        }
        return res;
    }

    public static double[] convert_double(Object[] array) {
        if (array == null) {
            return null;
        }
        double[] res = new double[array.length];
        int i = array.length;
        while (--i >= 0) {
            Object o = array[i];
            res[i] = ((Number)o).doubleValue();
        }
        return res;
    }

    public static boolean[] gconvert_boolean(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        boolean[] res = new boolean[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = (Boolean)o;
        }
        return res;
    }

    public static char[] gconvert_char(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        char[] res = new char[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Character)o).charValue();
        }
        return res;
    }

    public static byte[] gconvert_byte(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        byte[] res = new byte[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).byteValue();
        }
        return res;
    }

    public static short[] gconvert_short(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        short[] res = new short[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).shortValue();
        }
        return res;
    }

    public static int[] gconvert_int(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        int[] res = new int[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).intValue();
        }
        return res;
    }

    public static long[] gconvert_long(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        long[] res = new long[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).longValue();
        }
        return res;
    }

    public static float[] gconvert_float(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        float[] res = new float[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).floatValue();
        }
        return res;
    }

    public static double[] gconvert_double(Object array) {
        if (array == null) {
            return null;
        }
        int len = Array.getLength(array);
        double[] res = new double[len];
        int i = len;
        while (--i >= 0) {
            Object o = Array.get(array, i);
            res[i] = ((Number)o).doubleValue();
        }
        return res;
    }

    public static Object[] gconvert(Object array, String componentClass) {
        if (array == null) {
            return null;
        }
        try {
            int len = Array.getLength(array);
            Object[] res = (Object[])Array.newInstance(Class.forName(componentClass), len);
            boolean primitiveArray = componentClass.charAt(0) == '[' && componentClass.charAt(1) != 'L' && componentClass.charAt(1) != '[';
            boolean collection = componentClass.equals("java.util.Collection") || componentClass.equals("java.util.List");
            int i = len;
            while (--i >= 0) {
                Object value = Array.get(array, i);
                if (primitiveArray) {
                    value = rawArray.convertPrimitive(value, componentClass.substring(1));
                } else if (collection) {
                    value = rawArray.make(value);
                }
                Array.set(res, i, value);
            }
            return res;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not find class " + componentClass + " during array conversion");
        }
    }

    private static Object convertPrimitive(Object array, String component) {
        switch (component.charAt(0)) {
            case 'Z': {
                return rawArray.gconvert_boolean(array);
            }
            case 'B': {
                return rawArray.gconvert_byte(array);
            }
            case 'S': {
                return rawArray.gconvert_short(array);
            }
            case 'I': {
                return rawArray.gconvert_int(array);
            }
            case 'J': {
                return rawArray.gconvert_long(array);
            }
            case 'F': {
                return rawArray.gconvert_float(array);
            }
            case 'D': {
                return rawArray.gconvert_double(array);
            }
        }
        throw new Error("Unexpected error in array conversion");
    }

    public static void Array_set(Object array, int index, Object value) {
        if (array instanceof Object[]) {
            ((Object[])array)[index] = value;
        } else if (array instanceof int[]) {
            ((int[])array)[index] = ((Number)value).intValue();
        } else if (array instanceof byte[]) {
            ((byte[])array)[index] = ((Number)value).byteValue();
        } else if (array instanceof long[]) {
            ((long[])array)[index] = ((Number)value).longValue();
        } else if (array instanceof char[]) {
            ((char[])array)[index] = ((Character)value).charValue();
        } else if (array instanceof boolean[]) {
            ((boolean[])array)[index] = (Boolean)value;
        } else if (array instanceof double[]) {
            ((double[])array)[index] = ((Number)value).doubleValue();
        } else if (array instanceof float[]) {
            ((float[])array)[index] = ((Number)value).floatValue();
        } else if (array instanceof short[]) {
            ((short[])array)[index] = ((Number)value).shortValue();
        } else {
            throw new IllegalArgumentException();
        }
    }
}

