/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;

public class StackTarget
extends Target {
    Type type;
    public static final StackTarget intTarget = new StackTarget(Type.int_type);

    public StackTarget(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static Target getInstance(Type type) {
        return type == Type.pointer_type ? Target.pushObject : (type == Type.int_type ? intTarget : new StackTarget(type));
    }

    protected boolean compileFromStack0(Compilation comp, Type stackType) {
        return StackTarget.compileFromStack0(comp, stackType, this.type);
    }

    static boolean compileFromStack0(Compilation comp, Type stackType, Type type) {
        if (type == stackType) {
            return true;
        }
        CodeAttr code = comp.getCode();
        if (!code.reachableHere()) {
            return true;
        }
        if (stackType.isVoid()) {
            comp.compileConstant(null);
            stackType = Type.pointer_type;
        } else if (stackType instanceof PrimType && type instanceof PrimType) {
            code.emitConvert(stackType, type);
            return true;
        }
        if (code.topType().isAssignableTo(type)) {
            return true;
        }
        stackType.emitCoerceTo(type, code);
        if (code.topType().isAssignableTo(type)) {
            return true;
        }
        type.emitCoerceFrom(code.topType(), code);
        return code.topType().getImplementationType().isAssignableTo(type.getImplementationType());
    }

    public static void convert(Compilation comp, Type stackType, Type targetType) {
        if (!StackTarget.compileFromStack0(comp, stackType, targetType)) {
            targetType.emitCoerceFromObject(comp.getCode());
        }
    }

    public void compileFromStack(Compilation comp, Type stackType) {
        if (!this.compileFromStack0(comp, stackType)) {
            this.type.emitCoerceFromObject(comp.getCode());
        }
    }
}

