/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.PositionConsumer;
import gnu.lists.PositionContainer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;
import java.io.PrintWriter;

public class TreeList
extends AbstractSequence
implements Consumer,
PositionConsumer,
Consumable {
    public Object[] objects;
    static final Object availObject = new String("(AVAIL");
    public char[] data;
    public int gapStart;
    public int gapEnd;
    public int attrStart;
    static final int MAX_CHAR_SHORT = 40959;
    static final int MIN_INT_SHORT = -4096;
    static final int MAX_INT_SHORT = 8191;
    static final int INT_SHORT_ZERO = 49152;
    static final int OBJECT_REF_SHORT = 57344;
    static final int OBJECT_REF_SHORT_INDEX_MAX = 4095;
    static final char OBJECT_REF_FOLLOWS = '\uf10d';
    static final char POSITION_REF_FOLLOWS = '\uf10e';
    static final char POSITION_TRIPLE_FOLLOWS = '\uf10f';
    static final int BYTE_PREFIX = 61440;
    static final char BOOL_FALSE = '\uf100';
    static final char BOOL_TRUE = '\uf101';
    static final int INT_FOLLOWS = 61698;
    static final int LONG_FOLLOWS = 61699;
    static final int FLOAT_FOLLOWS = 61700;
    static final int DOUBLE_FOLLOWS = 61701;
    static final int CHAR_FOLLOWS = 61702;
    static final int CHAR_PAIR_FOLLOWS = 61703;
    static final int BEGIN_ATTRIBUTE_LONG = 61705;
    static final int END_ATTRIBUTE = 61706;
    static final int BEGIN_DOCUMENT = 61712;
    static final int BEGIN_GROUP_SHORT = 40960;
    static final int BEGIN_GROUP_SHORT_INDEX_MAX = 4095;
    static final int END_GROUP_SHORT = 61707;
    static final int BEGIN_GROUP_LONG = 61704;
    static final int END_GROUP_LONG = 61708;
    int currentBeginGroup = 0;

    public TreeList() {
        this.resizeObjects();
        this.gapEnd = 200;
        this.data = new char[this.gapEnd];
    }

    public TreeList(TreeList list, int startPosition, int endPosition) {
        this();
        list.consumeRange(startPosition, endPosition, this);
    }

    public TreeList(TreeList list) {
        this(list, 0, list.data.length);
    }

    public void clear() {
        this.gapStart = 0;
        this.gapEnd = this.data.length;
        this.attrStart = 0;
        if (this.gapEnd > 1500) {
            this.gapEnd = 200;
            this.data = new char[this.gapEnd];
        }
        this.objects = null;
        this.resizeObjects();
    }

    public void ensureSpace(int needed) {
        int avail = this.gapEnd - this.gapStart;
        if (needed > avail) {
            int afterGap;
            int oldSize = this.data.length;
            int newSize = 2 * oldSize;
            int neededSize = oldSize - avail + needed;
            if (newSize < neededSize) {
                newSize = neededSize;
            }
            char[] tmp = new char[newSize];
            if (this.gapStart > 0) {
                System.arraycopy(this.data, 0, tmp, 0, this.gapStart);
            }
            if ((afterGap = oldSize - this.gapEnd) > 0) {
                System.arraycopy(this.data, this.gapEnd, tmp, newSize - afterGap, afterGap);
            }
            this.gapEnd = newSize - afterGap;
            this.data = tmp;
        }
    }

    public final void resizeObjects() {
        Object[] tmp;
        int newLength;
        int oldLength;
        if (this.objects == null) {
            oldLength = 0;
            newLength = 100;
            tmp = new Object[newLength];
        } else {
            oldLength = this.objects.length;
            newLength = 2 * oldLength;
            tmp = new Object[newLength];
            System.arraycopy(this.objects, 0, tmp, 0, oldLength);
        }
        Object availObject = TreeList.availObject;
        for (int i = oldLength; i < newLength; ++i) {
            tmp[i] = availObject;
        }
        this.objects = tmp;
    }

    protected int find(Object arg1) {
        int len = this.objects.length;
        Object availObject = TreeList.availObject;
        int avail = -1;
        for (int i = 0; i < len; ++i) {
            Object obj = this.objects[i];
            if (obj == arg1) {
                return i;
            }
            if (obj != availObject || avail >= 0) continue;
            avail = i;
        }
        if (avail >= 0) {
            this.objects[avail] = arg1;
            return avail;
        }
        this.resizeObjects();
        this.objects[len] = arg1;
        return len;
    }

    protected int find(Object arg1, Object arg2) {
        int i = 0;
        int len = this.objects.length;
        Object availObject = TreeList.availObject;
        int avail = -1;
        Object[] objects = this.objects;
        while (i + 1 < len) {
            Object obj1 = objects[i];
            if (obj1 == arg1 && objects[i + 1] == arg2) {
                return i;
            }
            if (avail < 0 && obj1 == availObject && objects[i + 1] == availObject) {
                avail = i;
            }
            ++i;
        }
        if (avail >= 0) {
            objects[avail] = arg1;
            objects[avail + 1] = arg2;
            return avail;
        }
        this.resizeObjects();
        objects = this.objects;
        objects[len] = arg1;
        objects[len + 1] = arg2;
        return len;
    }

    protected final int getIntN(int index) {
        return this.data[index] << 16 | this.data[index + 1];
    }

    protected final long getLongN(int index) {
        char[] data = this.data;
        return data[index] << 48 | data[index + 1] << 32 | data[index + 2] << 16 | data[index + 3];
    }

    public final void setIntN(int index, int i) {
        this.data[index] = (char)(i >> 16);
        this.data[index + 1] = (char)i;
    }

    public boolean consume(TreePosition position) {
        this.ensureSpace(3);
        int index = this.find(new TreePosition(position));
        this.data[this.gapStart++] = 61710;
        this.setIntN(this.gapStart, index);
        this.gapStart += 2;
        return true;
    }

    public boolean writePosition(AbstractSequence seq, int ipos, Object xpos) {
        this.ensureSpace(7);
        this.data[this.gapStart] = 61711;
        int seq_index = this.find(seq);
        int xpos_index = xpos == null ? -1 : this.find(xpos);
        this.setIntN(this.gapStart + 1, seq_index);
        this.setIntN(this.gapStart + 3, ipos);
        this.setIntN(this.gapStart + 5, xpos_index);
        this.gapStart += 7;
        return true;
    }

    public void writeObject(Object v) {
        if (v instanceof SeqPosition) {
            SeqPosition pos = (SeqPosition)v;
            this.writePosition(pos.sequence, pos.ipos, pos.xpos);
            return;
        }
        this.ensureSpace(3);
        int index = this.find(v);
        if (index < 4096) {
            this.data[this.gapStart++] = (char)(0xE000 | index);
        } else {
            this.data[this.gapStart++] = 61709;
            this.setIntN(this.gapStart, index);
            this.gapStart += 2;
        }
    }

    public void beginGroup(String typeName, Object type) {
        this.beginGroup(this.find(typeName, type));
    }

    public void beginDocument() {
        this.ensureSpace(1);
        this.data[this.gapStart++] = 61712;
    }

    public void endDocument() {
    }

    public void beginGroup(int index) {
        this.ensureSpace(10);
        this.gapEnd -= 7;
        this.data[this.gapStart++] = 61704;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61708;
        this.setIntN(this.gapEnd + 1, index);
        this.setIntN(this.gapEnd + 3, this.gapStart - 3);
        this.setIntN(this.gapEnd + 5, this.currentBeginGroup);
        this.currentBeginGroup = this.gapStart - 3;
    }

    public void endGroup(String typeName) {
        if (this.data[this.gapEnd] != '\uf10c') {
            throw new Error("unexpected endGroup " + typeName);
        }
        int index = this.getIntN(this.gapEnd + 1);
        int begin = this.getIntN(this.gapEnd + 3);
        int parent = this.getIntN(this.gapEnd + 5);
        this.gapEnd += 7;
        int offset = this.gapStart - begin;
        int parentOffset = begin - parent;
        if (index < 4095 && offset < 65536 && parentOffset < 65536) {
            this.data[begin] = (char)(0xA000 | index);
            this.data[begin + 1] = (char)offset;
            this.data[begin + 2] = (char)parentOffset;
            this.data[this.gapStart] = 61707;
            this.data[this.gapStart + 1] = (char)offset;
            this.gapStart += 2;
        } else {
            this.data[begin] = 61704;
            this.setIntN(begin + 1, offset);
            this.data[this.gapStart] = 61708;
            this.setIntN(this.gapStart + 1, index);
            this.setIntN(this.gapStart + 3, -offset);
            if (parent >= this.gapStart || begin <= this.gapStart) {
                parent -= this.gapStart;
            }
            this.setIntN(this.gapStart + 5, parent);
            this.gapStart += 7;
        }
        this.currentBeginGroup = parent;
    }

    public void beginAttribute(String attrName, Object attrType) {
        this.beginAttribute(this.find(attrName, attrType));
    }

    public void beginAttribute(int index) {
        this.ensureSpace(6);
        --this.gapEnd;
        this.data[this.gapStart++] = 61705;
        if (this.attrStart != 0) {
            throw new Error("nested attribute");
        }
        this.attrStart = this.gapStart;
        this.setIntN(this.gapStart, index);
        this.setIntN(this.gapStart + 2, this.gapEnd - this.data.length);
        this.gapStart += 4;
        this.data[this.gapEnd] = 61706;
    }

    public void endAttribute() {
        if (this.data[this.gapEnd] != '\uf10a' || this.attrStart <= 0) {
            throw new Error("unexpected endAttribute");
        }
        ++this.gapEnd;
        this.setIntN(this.attrStart + 2, this.gapStart - this.attrStart + 1);
        this.attrStart = 0;
        this.data[this.gapStart++] = 61706;
    }

    public void writeChar(int i) {
        this.ensureSpace(3);
        if (i <= 40959) {
            this.data[this.gapStart++] = (char)i;
        } else if (i < 65536) {
            this.data[this.gapStart++] = 61702;
            this.data[this.gapStart++] = (char)i;
        } else {
            this.data[this.gapStart++] = 61703;
        }
    }

    public void writeBoolean(boolean v) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = v ? 61697 : 61696;
    }

    public void writeByte(int v) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = (char)(61440 + (v & 0xFF));
    }

    public void writeInt(int v) {
        this.ensureSpace(3);
        if (v >= -4096 && v <= 8191) {
            this.data[this.gapStart++] = (char)(49152 + v);
        } else {
            this.data[this.gapStart++] = 61698;
            this.setIntN(this.gapStart, v);
            this.gapStart += 2;
        }
    }

    public void writeLong(long v) {
        this.ensureSpace(5);
        this.data[this.gapStart++] = 61699;
        this.data[this.gapStart++] = (char)(v >>> 48);
        this.data[this.gapStart++] = (char)(v >>> 32);
        this.data[this.gapStart++] = (char)(v >>> 16);
        this.data[this.gapStart++] = (char)v;
    }

    public void writeFloat(float v) {
        this.ensureSpace(3);
        int i = Float.floatToIntBits(v);
        this.data[this.gapStart++] = 61700;
        this.data[this.gapStart++] = (char)(i >>> 16);
        this.data[this.gapStart++] = (char)i;
    }

    public void writeDouble(double v) {
        this.ensureSpace(5);
        long l = Double.doubleToLongBits(v);
        this.data[this.gapStart++] = 61701;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(str.charAt(i));
        }
    }

    public void write(char[] buf, int off, int len) {
        this.ensureSpace(len);
        while (len > 0) {
            char ch = buf[off++];
            --len;
            if (ch <= '\u9fff') {
                this.data[this.gapStart++] = ch;
                continue;
            }
            this.writeChar(ch);
            this.ensureSpace(len);
        }
    }

    public boolean isEmpty() {
        int pos = this.gapStart == 0 ? this.gapEnd : 0;
        return pos == this.data.length;
    }

    public int size() {
        int size = 0;
        int i = 0;
        while ((i = this.nextDataIndex(i)) >= 0) {
            ++size;
        }
        return size;
    }

    protected void makePosition(int index, boolean isAfter, PositionContainer posSet, int posNumber) {
        int i = 0;
        while (--index >= 0) {
            if ((i = this.nextDataIndex(i)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        posSet.setPosition(posNumber, i << 1 | (isAfter ? 1 : 0), null);
        posSet.setSequence(posNumber, this);
    }

    public boolean gotoChildrenStart(TreePosition pos) {
        int index = this.gotoChildrenStart(pos.ipos >> 1);
        if (index < 0) {
            return false;
        }
        pos.push(this, index << 1, null);
        return true;
    }

    public int gotoChildrenStart(int index) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return -1;
        }
        char datum = this.data[index];
        if (datum >= '\ua000' && datum <= '\uafff' || datum == '\uf108') {
            index += 3;
        } else {
            if (datum == '\uf110') {
                return index + 1;
            }
            return -1;
        }
        while (true) {
            if (index >= this.gapStart) {
                index += this.gapEnd - this.gapStart;
            }
            if ((datum = this.data[index]) == '\uf109') {
                int end;
                index = end + ((end = this.getIntN(index + 3)) < 0 ? this.data.length : index);
                continue;
            }
            if (datum != '\uf10a') break;
            ++index;
        }
        return index;
    }

    public boolean gotoAttributesStart(TreePosition pos) {
        int index = this.gotoAttributesStart(pos.ipos >> 1);
        if (index < 0) {
            return false;
        }
        pos.push(this, index << 1, null);
        return true;
    }

    public int gotoAttributesStart(int index) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return -1;
        }
        char datum = this.data[index];
        if (datum >= '\ua000' && datum <= '\uafff' || datum == '\uf108') {
            return index + 3;
        }
        return -1;
    }

    public Object get(int index) {
        throw this.unsupported("get");
    }

    public boolean consumeNext(int ipos, Object xpos, Consumer out) {
        if (!this.hasNext(ipos, xpos)) {
            return false;
        }
        int start = ipos >> 1;
        int end = this.nextDataIndex(start);
        if (end >= 0) {
            this.consumeRange(start, end, out);
        }
        return true;
    }

    public int consumeRange(int startPosition, int endPosition, Consumer out) {
        int pos;
        block28: {
            char datum;
            int limit;
            pos = startPosition;
            int n = limit = startPosition <= this.gapStart && endPosition > this.gapStart ? this.gapStart : endPosition;
            block18: while (true) {
                int index;
                if (pos >= limit) {
                    if (pos != this.gapStart || endPosition <= this.gapEnd) break block28;
                    pos = this.gapEnd;
                    limit = endPosition;
                }
                if ((datum = this.data[pos++]) <= '\u9fff') {
                    int start = pos - 1;
                    int lim = limit;
                    while (pos < lim) {
                        if ((datum = this.data[pos++]) <= '\u9fff') continue;
                        --pos;
                        break;
                    }
                    out.write(this.data, start, pos - start);
                    continue;
                }
                if (datum >= '\ue000' && datum <= '\uefff') {
                    out.writeObject(this.objects[datum - 57344]);
                    continue;
                }
                if (datum >= '\ua000' && datum <= '\uafff') {
                    index = datum - 40960;
                    out.beginGroup(this.objects[index].toString(), this.objects[index + 1]);
                    pos += 2;
                    continue;
                }
                if (datum >= '\ub000' && datum <= '\udfff') {
                    out.writeInt(datum - 49152);
                    continue;
                }
                switch (datum) {
                    case '\uf110': {
                        continue block18;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        out.writeBoolean(datum != '\uf100');
                        continue block18;
                    }
                    case '\uf106': {
                        out.write(this.data, pos, '\u0001' + datum - 61702);
                        ++pos;
                        continue block18;
                    }
                    case '\uf107': {
                        out.write(this.data, pos, '\u0001' + datum - 61702);
                        pos += 2;
                        continue block18;
                    }
                    case '\uf10f': {
                        Object xpos;
                        AbstractSequence seq = (AbstractSequence)this.objects[this.getIntN(pos)];
                        int ipos = this.getIntN(pos + 2);
                        int xpos_index = this.getIntN(pos + 4);
                        Object object = xpos = xpos_index < 0 ? null : this.objects[xpos_index];
                        if (out instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)out)).writePosition(seq, ipos, xpos);
                        } else {
                            out.writeObject(SeqPosition.make(seq, ipos, xpos));
                        }
                        pos += 6;
                        continue block18;
                    }
                    case '\uf10e': {
                        if (out instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)out)).consume((TreePosition)this.objects[this.getIntN(pos)]);
                            pos += 2;
                            continue block18;
                        }
                    }
                    case '\uf10d': {
                        out.writeObject(this.objects[this.getIntN(pos)]);
                        pos += 2;
                        continue block18;
                    }
                    case '\uf10b': {
                        index = this.data[pos++];
                        index = this.data[pos - 2 - index] - 40960;
                        out.endGroup(this.objects[index].toString());
                        continue block18;
                    }
                    case '\uf108': {
                        index = this.getIntN(pos);
                        index += index >= 0 ? (pos += 2) - 1 : this.data.length;
                        index = this.getIntN(index + 1);
                        out.beginGroup(this.objects[index].toString(), this.objects[index + 1]);
                        continue block18;
                    }
                    case '\uf10c': {
                        index = this.getIntN(pos);
                        out.endGroup(this.objects[index].toString());
                        pos += 6;
                        continue block18;
                    }
                    case '\uf109': {
                        index = this.getIntN(pos);
                        out.beginAttribute(this.objects[index].toString(), this.objects[index + 1]);
                        pos += 4;
                        continue block18;
                    }
                    case '\uf10a': {
                        out.endAttribute();
                        continue block18;
                    }
                    case '\uf102': {
                        this.writeInt(this.getIntN(pos));
                        pos += 2;
                        continue block18;
                    }
                    case '\uf104': {
                        this.writeFloat(Float.intBitsToFloat(this.getIntN(pos)));
                        pos += 2;
                        continue block18;
                    }
                    case '\uf103': {
                        this.writeLong(this.getLongN(pos));
                        pos += 4;
                        continue block18;
                    }
                    case '\uf105': {
                        this.writeDouble(Double.longBitsToDouble(this.getLongN(pos)));
                        pos += 4;
                        continue block18;
                    }
                }
                break;
            }
            this.dump();
            throw new Error("unknown code:" + datum);
        }
        return pos;
    }

    public boolean hasNext(int ipos, Object xpos) {
        int index = ipos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return false;
        }
        char ch = this.data[index];
        return ch != '\uf10a' && ch != '\uf10b' && ch != '\uf10c';
    }

    public int getNextKind(int ipos, Object xpos) {
        int index = ipos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return 0;
        }
        char datum = this.data[index];
        if (datum <= '\u9fff') {
            return 29;
        }
        if (datum >= '\ue000' && datum <= '\uefff') {
            return 32;
        }
        if (datum >= '\ua000' && datum <= '\uafff') {
            return 33;
        }
        if ((datum & 0xFF00) == 61440) {
            return 28;
        }
        if (datum >= '\ub000' && datum <= '\udfff') {
            return 22;
        }
        switch (datum) {
            case '\uf100': 
            case '\uf101': {
                return 27;
            }
            case '\uf102': {
                return 22;
            }
            case '\uf103': {
                return 24;
            }
            case '\uf104': {
                return 25;
            }
            case '\uf105': {
                return 26;
            }
            case '\uf106': 
            case '\uf107': {
                return 29;
            }
            case '\uf110': {
                return 34;
            }
            case '\uf108': {
                return 33;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': {
                return 0;
            }
            case '\uf109': {
                return 35;
            }
        }
        return 32;
    }

    protected int getNextTypeIndex(int ipos, Object xpos) {
        int index = ipos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return 0;
        }
        char datum = this.data[index];
        if (datum >= '\ua000' && datum <= '\uafff') {
            return datum - 40960;
        }
        if (datum == '\uf108' || datum == '\uf109') {
            return this.getIntN(index + 1);
        }
        return -1;
    }

    public String getNextTypeName(int ipos, Object xpos) {
        int index = this.getNextTypeIndex(ipos, xpos);
        return index < 0 ? null : (String)this.objects[index];
    }

    public Object getNextTypeObject(int ipos, Object xpos) {
        int index = this.getNextTypeIndex(ipos, xpos);
        return index < 0 ? null : this.objects[index + 1];
    }

    public Object getNext(int ipos, Object xpos) {
        int index = ipos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return Sequence.eofValue;
        }
        char datum = this.data[index];
        if (datum <= '\u9fff') {
            return Convert.toObject(datum);
        }
        if (datum >= '\ue000' && datum <= '\uefff') {
            return this.objects[datum - 57344];
        }
        if (datum >= '\ua000' && datum <= '\uafff') {
            return new TreeList(this, index, index + this.data[index + 1] + 2);
        }
        if (datum >= '\ub000' && datum <= '\udfff') {
            return Convert.toObject(datum - 49152);
        }
        switch (datum) {
            case '\uf110': {
                return this;
            }
            case '\uf100': 
            case '\uf101': {
                return Convert.toObject(datum != '\uf100');
            }
            case '\uf102': {
                return Convert.toObject(this.getIntN(index + 1));
            }
            case '\uf103': {
                return Convert.toObject(this.getLongN(index + 1));
            }
            case '\uf104': {
                return Convert.toObject(Float.intBitsToFloat(this.getIntN(index + 1)));
            }
            case '\uf105': {
                return Convert.toObject(Double.longBitsToDouble(this.getLongN(index + 1)));
            }
            case '\uf106': {
                return Convert.toObject(this.data[index + 1]);
            }
            case '\uf109': {
                int end_offset = this.getIntN(index + 3);
                return new TreeList(this, index, (end_offset += end_offset < 0 ? this.data.length : index) + 1);
            }
            case '\uf108': {
                int end_offset = this.getIntN(index + 1);
                return new TreeList(this, index, (end_offset += end_offset < 0 ? this.data.length : index) + 7);
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': {
                return Sequence.eofValue;
            }
            case '\uf10d': 
            case '\uf10e': {
                return this.objects[this.getIntN(index + 1)];
            }
            case '\uf10f': {
                AbstractSequence seq = (AbstractSequence)this.objects[this.getIntN(index + 1)];
                ipos = this.getIntN(index + 3);
                int xpos_index = this.getIntN(index + 5);
                xpos = xpos_index < 0 ? null : this.objects[xpos_index];
                return SeqPosition.make(seq, ipos, xpos);
            }
        }
        throw this.unsupported("getNext, code=" + Integer.toHexString(datum));
    }

    public int stringValue(int index, StringBuffer sbuf) {
        return this.stringValue(false, index, sbuf);
    }

    public int stringValue(boolean inGroup, int index, StringBuffer sbuf) {
        Object value = null;
        int doChildren = 0;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index == this.data.length) {
            return -1;
        }
        char datum = this.data[index];
        ++index;
        if (datum <= '\u9fff') {
            sbuf.append(datum);
            return index;
        }
        if (datum >= '\ue000' && datum <= '\uefff') {
            value = this.objects[datum - 57344];
        } else if (datum >= '\ua000' && datum <= '\uafff') {
            doChildren = index + 2;
            index = this.data[index] + index + 1;
        } else {
            if ((datum & 0xFF00) == 61440) {
                sbuf.append(datum & 0xFF);
                return index;
            }
            if (datum >= '\ub000' && datum <= '\udfff') {
                sbuf.append(datum - 49152);
                return index;
            }
            switch (datum) {
                case '\uf100': 
                case '\uf101': {
                    sbuf.append(datum != '\uf100');
                    return index;
                }
                case '\uf102': {
                    sbuf.append(this.getIntN(index + 1));
                    return index + 2;
                }
                case '\uf103': {
                    sbuf.append(this.getLongN(index + 1));
                    return index + 4;
                }
                case '\uf104': {
                    sbuf.append(Float.intBitsToFloat(this.getIntN(index + 1)));
                    return index + 2;
                }
                case '\uf105': {
                    sbuf.append(Double.longBitsToDouble(this.getLongN(index + 1)));
                    return index + 4;
                }
                case '\uf106': {
                    sbuf.append(this.data[index + 1]);
                    return index + 1;
                }
                case '\uf110': {
                    doChildren = 1;
                    index = this.data.length;
                    break;
                }
                case '\uf108': {
                    doChildren = index + 2;
                    int j = this.getIntN(index);
                    index = (j += j < 0 ? this.data.length : index - 1) + 7;
                    break;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': {
                    return -1;
                }
                case '\uf109': {
                    int end;
                    if (!inGroup) {
                        doChildren = index + 4;
                    }
                    index = end + ((end = this.getIntN(index + 2)) < 0 ? this.data.length + 1 : index);
                    break;
                }
                default: {
                    throw new Error("unimplemented");
                }
            }
        }
        if (value != null) {
            sbuf.append(value);
        }
        if (doChildren > 0) {
            while ((doChildren = this.stringValue(true, doChildren, sbuf)) >= 0) {
            }
        }
        return index;
    }

    protected void makeRelativePosition(int istart, Object xstart, int offset, boolean isAfter, PositionContainer posSet, int posNumber) {
        if (offset < 0) {
            throw this.unsupported("backwards makeRelativePostion");
        }
        int pos = istart >>> 1;
        while (--offset >= 0) {
            if ((pos = this.nextDataIndex(pos)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        posSet.setPosition(posNumber, pos << 1 | (isAfter ? 1 : 0), null);
    }

    public int nextDataIndex(int pos) {
        char datum;
        if (pos == this.gapStart) {
            pos = this.gapEnd;
        }
        if (pos == this.data.length) {
            return -1;
        }
        if ((datum = this.data[pos++]) <= '\u9fff' || datum >= '\ue000' && datum <= '\uefff' || datum >= '\ub000' && datum <= '\udfff') {
            return pos;
        }
        if (datum >= '\ua000' && datum <= '\uafff') {
            return this.data[pos] + pos + 1;
        }
        switch (datum) {
            case '\uf110': {
                return this.data.length;
            }
            case '\uf100': 
            case '\uf101': {
                return pos;
            }
            case '\uf106': {
                return pos + 1;
            }
            case '\uf102': 
            case '\uf107': 
            case '\uf10d': 
            case '\uf10e': {
                return pos + 2;
            }
            case '\uf10f': {
                return pos + 6;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': {
                return -1;
            }
            case '\uf108': {
                int j = this.getIntN(pos);
                return (j += j < 0 ? this.data.length : pos - 1) + 7;
            }
            case '\uf109': {
                int j = this.getIntN(pos + 2);
                return (j += j < 0 ? this.data.length : pos - 1) + 1;
            }
            case '\uf103': 
            case '\uf105': {
                return pos + 4;
            }
        }
        throw new Error("unknown code:" + datum);
    }

    public void consume(Consumer out) {
        this.consumeRange(0, this.data.length, out);
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        out.println("TreeList @" + System.identityHashCode(this) + " gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + " length:" + this.data.length);
        int toskip = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (i >= this.gapStart && i < this.gapEnd) continue;
            int ch = this.data[i];
            out.print("" + i + ": 0x" + Integer.toHexString(ch) + '=' + (short)ch);
            if (--toskip < 0) {
                if (ch <= 40959) {
                    if (ch >= 32 && ch < 127) {
                        out.print("='" + (char)ch + "'");
                    } else if (ch == 10) {
                        out.print("='\\n'");
                    } else {
                        out.print("='\\u" + Integer.toHexString(ch) + "'");
                    }
                } else if (ch >= 57344 && ch <= 61439) {
                    Object obj = this.objects[ch -= 57344];
                    out.print("=Object#" + ch + '=' + obj + ':' + obj.getClass().getName());
                } else if (ch >= 40960 && ch <= 45055) {
                    out.print("=BEGIN_GROUP_SHORT index#" + (ch -= 40960) + "=<" + this.objects[ch] + "::" + this.objects[ch + 1] + '>');
                    toskip = 2;
                } else if (ch >= 45056 && ch <= 57343) {
                    out.print("= INT_SHORT:" + (ch - 49152));
                } else {
                    switch (ch) {
                        case 61698: {
                            int j = this.getIntN(i + 1);
                            out.print("=INT_FOLLOWS value:" + j);
                            toskip = 2;
                            break;
                        }
                        case 61699: {
                            long l = this.getLongN(i + 1);
                            out.print("=LONG_FOLLOWS value:" + l);
                            toskip = 4;
                            break;
                        }
                        case 61700: {
                            int j = this.getIntN(i + 1);
                            out.print("=FLOAT_FOLLOWS value:" + Float.intBitsToFloat(j));
                            toskip = 2;
                            break;
                        }
                        case 61701: {
                            long l = this.getLongN(i + 1);
                            out.print("=DOUBLE_FOLLOWS value:" + Double.longBitsToDouble(l));
                            toskip = 4;
                            break;
                        }
                        case 61712: {
                            out.print("=BEGIN_DOCUMENT");
                            break;
                        }
                        case 61696: {
                            out.print("= false");
                            break;
                        }
                        case 61697: {
                            out.print("= true");
                            break;
                        }
                        case 61702: {
                            out.print("=CHAR_FOLLOWS");
                            toskip = 1;
                            break;
                        }
                        case 61703: {
                            out.print("=CHAR_PAIR_FOLLOWS");
                            toskip = 2;
                            break;
                        }
                        case 61709: 
                        case 61710: {
                            toskip = 2;
                            break;
                        }
                        case 61707: {
                            out.print("=END_GROUP_SHORT begin:");
                            int j = i - this.data[i + 1];
                            out.print(j);
                            j = this.data[j] - 40960;
                            out.print(" -> #" + j + "=<" + this.objects[j] + '>');
                            toskip = 1;
                            break;
                        }
                        case 61704: {
                            int j = this.getIntN(i + 1);
                            out.print("=BEGIN_GROUP_LONG end:" + (j += j < 0 ? this.data.length : i));
                            j = this.getIntN(j + 1);
                            out.print(" -> #" + j + "=<" + this.objects[j] + "::" + this.objects[j + 1] + '>');
                            toskip = 2;
                            break;
                        }
                        case 61708: {
                            int j = this.getIntN(i + 1);
                            out.print("=END_GROUP_LONG name:" + j + "=<" + this.objects[j] + '>');
                            j = this.getIntN(i + 3);
                            j = j < 0 ? i + j : j;
                            out.print(" begin:" + j);
                            j = this.getIntN(i + 5);
                            j = j < 0 ? i + j : j;
                            out.print(" parent:" + j);
                            toskip = 6;
                            break;
                        }
                        case 61705: {
                            int j = this.getIntN(i + 1);
                            out.print("=BEGIN_ATTRIBUTE name:" + j + "=" + this.objects[j]);
                            j = this.getIntN(i + 3);
                            out.print(" end:" + (j += j < 0 ? this.data.length : i));
                            toskip = 4;
                            break;
                        }
                        case 61706: {
                            out.print("=END_ATTRIBUTE");
                            break;
                        }
                        case 61711: {
                            out.print("=POSITION_TRIPLE_FOLLOWS seq:");
                            int j = this.getIntN(i + 1);
                            out.print(j);
                            out.print("=@");
                            Object seq = this.objects[j];
                            if (seq == null) {
                                out.print("null");
                            } else {
                                out.print(System.identityHashCode(seq));
                            }
                            out.print(" ipos:");
                            out.print(this.getIntN(i + 3));
                            out.print(" xpos:");
                            out.print(this.getIntN(i + 5));
                            toskip = 6;
                        }
                    }
                }
            }
            out.println();
        }
    }
}

