/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import mlsub.typing.AtomicConstraint;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public final class Constraint {
    public static final Constraint True = null;
    private TypeSymbol[] binders;
    private int nbinders;
    private AtomicConstraint[] atoms;
    private int natoms;

    public Constraint(TypeSymbol[] binders, AtomicConstraint[] atoms) {
        this.binders = binders;
        if (binders != null) {
            this.nbinders = binders.length;
        }
        this.atoms = atoms;
        if (atoms != null) {
            this.natoms = atoms.length;
        }
    }

    public static final Constraint create(TypeSymbol[] binders, AtomicConstraint[] atoms) {
        if (binders == null && atoms == null) {
            return True;
        }
        if (binders != null && binders.length == 0) {
            throw new Error("Please optimize");
        }
        if (atoms != null && atoms.length == 0) {
            throw new Error("Please optimize");
        }
        return new Constraint(binders, atoms);
    }

    private Constraint() {
    }

    public static final boolean hasBinders(Constraint c) {
        return c != null && c.binders != null;
    }

    public static final boolean trivial(Constraint c) {
        return c == null || c.natoms == 0;
    }

    public TypeSymbol[] binders() {
        return this.binders;
    }

    public AtomicConstraint[] atoms() {
        return this.atoms;
    }

    public static Constraint and(Constraint c1, Constraint c2) {
        int i;
        int natoms2;
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int n = natoms2 = c2 == null ? 0 : c2.natoms;
        if (nbinders1 == 0 && nbinders2 == 0 && natoms1 == 0 && natoms2 == 0) {
            return True;
        }
        Constraint res = new Constraint();
        res.nbinders = nbinders1 + nbinders2;
        res.natoms = natoms1 + natoms2;
        if (res.nbinders > 0) {
            res.binders = new TypeSymbol[res.nbinders];
            for (i = 0; i < nbinders1; ++i) {
                res.binders[i] = c1.binders[i];
            }
            for (i = 0; i < nbinders2; ++i) {
                res.binders[nbinders1 + i] = c2.binders[i];
            }
        }
        if (res.natoms > 0) {
            res.atoms = new AtomicConstraint[res.natoms];
            for (i = 0; i < natoms1; ++i) {
                res.atoms[i] = c1.atoms[i];
            }
            for (i = 0; i < natoms2; ++i) {
                res.atoms[natoms1 + i] = c2.atoms[i];
            }
        }
        return res;
    }

    public static Constraint and(Constraint c1, TypeSymbol t0, TypeSymbol t1, AtomicConstraint a1, AtomicConstraint a2) {
        int i;
        int nbinders = (c1 == null ? 0 : c1.nbinders) + 2;
        int natoms = (c1 == null ? 0 : c1.natoms) + 2;
        Constraint res = new Constraint();
        res.nbinders = nbinders;
        res.natoms = natoms;
        res.binders = new TypeSymbol[nbinders];
        for (i = 0; i < nbinders - 2; ++i) {
            res.binders[i] = c1.binders[i];
        }
        res.binders[nbinders - 2] = t0;
        res.binders[nbinders - 1] = t1;
        res.atoms = new AtomicConstraint[res.natoms];
        for (i = 0; i < natoms - 2; ++i) {
            res.atoms[i] = c1.atoms[i];
        }
        res.atoms[natoms - 2] = a2;
        res.atoms[natoms - 1] = a1;
        return res;
    }

    static Constraint and(TypeSymbol m, Constraint c1, Constraint c2, AtomicConstraint a1, AtomicConstraint a2) {
        int i;
        Constraint res = new Constraint();
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        res.nbinders = nbinders1 + nbinders2 + 1;
        res.binders = new TypeSymbol[res.nbinders];
        for (i = 0; i < nbinders1; ++i) {
            res.binders[i] = c1.binders[i];
        }
        for (i = 0; i < nbinders2; ++i) {
            res.binders[nbinders1 + i] = c2.binders[i];
        }
        res.binders[res.nbinders - 1] = m;
        res.natoms = natoms1 + natoms2 + 2;
        res.atoms = new AtomicConstraint[res.natoms];
        for (i = 0; i < natoms1; ++i) {
            res.atoms[i] = c1.atoms[i];
        }
        for (i = 0; i < natoms2; ++i) {
            res.atoms[natoms1 + i] = c2.atoms[i];
        }
        res.atoms[res.natoms - 2] = a2;
        res.atoms[res.natoms - 1] = a1;
        return res;
    }

    static Constraint and(Constraint c1, Constraint c2, AtomicConstraint a1) {
        int i;
        Constraint res = new Constraint();
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        res.nbinders = nbinders1 + nbinders2;
        res.binders = new TypeSymbol[res.nbinders];
        for (i = 0; i < nbinders1; ++i) {
            res.binders[i] = c1.binders[i];
        }
        for (i = 0; i < nbinders2; ++i) {
            res.binders[nbinders1 + i] = c2.binders[i];
        }
        res.natoms = natoms1 + natoms2 + 1;
        res.atoms = new AtomicConstraint[res.natoms];
        for (i = 0; i < natoms1; ++i) {
            res.atoms[i] = c1.atoms[i];
        }
        for (i = 0; i < natoms2; ++i) {
            res.atoms[natoms1 + i] = c2.atoms[i];
        }
        res.atoms[res.natoms - 1] = a1;
        return res;
    }

    public static Constraint and(Constraint[] cs, Constraint c1, Constraint c2) {
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        int lenBinders = nbinders1 + nbinders2;
        int lenAtoms = natoms1 + natoms2;
        for (int i = 0; i < cs.length; ++i) {
            Constraint c = cs[i];
            if (c == True) continue;
            lenBinders += cs[i].nbinders;
            lenAtoms += cs[i].natoms;
        }
        if (lenAtoms == 0 && lenBinders == 0) {
            return True;
        }
        Constraint res = new Constraint();
        if (lenBinders > 0) {
            int i;
            res.nbinders = lenBinders;
            res.binders = new TypeSymbol[lenBinders];
            for (i = 0; i < nbinders2; ++i) {
                res.binders[--lenBinders] = c2.binders[i];
            }
            for (i = 0; i < nbinders1; ++i) {
                res.binders[--lenBinders] = c1.binders[i];
            }
        }
        if (lenAtoms > 0) {
            int i;
            res.natoms = lenAtoms;
            res.atoms = new AtomicConstraint[lenAtoms];
            for (i = 0; i < natoms2; ++i) {
                res.atoms[--lenAtoms] = c2.atoms[i];
            }
            for (i = 0; i < natoms1; ++i) {
                res.atoms[--lenAtoms] = c1.atoms[i];
            }
        }
        for (int j = 0; j < cs.length; ++j) {
            int i;
            Constraint c = cs[j];
            if (c == True) continue;
            for (i = 0; i < c.nbinders; ++i) {
                res.binders[--lenBinders] = c.binders[i];
            }
            for (i = 0; i < c.natoms; ++i) {
                res.atoms[--lenAtoms] = c.atoms[i];
            }
        }
        return res;
    }

    public static void enter(Constraint c) throws TypingEx {
        if (c != null) {
            c.enter();
        }
    }

    public void enter() throws TypingEx {
        if (this.binders != null) {
            Typing.introduceTypeSymbols(this.binders);
        }
        if (this.atoms != null) {
            for (int i = 0; i < this.natoms; ++i) {
                this.atoms[i].enter();
            }
        }
    }

    public void enter(boolean existential) throws TypingEx {
        if (existential && this.binders != null) {
            for (int i = 0; i < this.nbinders; ++i) {
                if (!(this.binders[i] instanceof MonotypeVar)) continue;
                ((MonotypeVar)this.binders[i]).setExistential();
            }
        }
        this.enter();
    }

    public String toString() {
        int i;
        StringBuffer res = new StringBuffer("<");
        for (i = 0; i < this.nbinders; ++i) {
            res.append(this.binders[i].toString());
            if (i >= this.nbinders - 1) continue;
            res.append(", ");
        }
        if (this.nbinders > 0 && this.natoms > 0) {
            res.append(" | ");
        }
        for (i = 0; i < this.natoms; ++i) {
            res.append(String.valueOf(this.atoms[i]));
            if (i >= this.natoms - 1) continue;
            res.append(", ");
        }
        res.append("> ");
        return res.toString();
    }

    public static String toString(Constraint c) {
        if (c == True) {
            return "";
        }
        return c.toString();
    }
}

