/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite.output;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class OutputWriter
extends FilterWriter {
    private StringBuffer _buf = new StringBuffer();
    private int _mark = 0;

    public OutputWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(String str) throws IOException {
        this._buf.append(str);
    }

    @Override
    public void write(char[] chArray) throws IOException {
        this._buf.append(chArray);
    }

    @Override
    public void write(String str, int offset, int length) throws IOException {
        this._buf.append(str.substring(offset, length));
    }

    @Override
    public void write(int ch) {
        this._buf.append(ch);
    }

    @Override
    public void write(char[] chArray, int offset, int length) throws IOException {
        this._buf.append(new String(chArray).substring(offset, length));
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this._buf.toString());
        this.out.flush();
        this._mark = 0;
        this.reset();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void mark() {
        this._mark = this._buf.length();
    }

    public void reset() {
        this._buf.delete(this._mark, this._buf.length());
    }
}

