#ifndef __NJAMD_NJAMD_H__
#define __NJAMD_NJAMD_H__

#include <config.h>

/*
 * Include every file needed by the various packages.  This way, we only
 * need to insert the #ifdef HAVE_STRING_H things from config.h here.  It
 * will slow down compilation, but oh well...
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <signal.h>
#undef ERR /* Stupid RH 6.2 */
#ifdef HAVE_NCURSES_H
# include <ncurses.h>
#elif HAVE_CURSES_H
# include <curses.h>
#endif
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_GTK
# include <gtk/gtk.h>
# include <X11/Xlib.h>
#endif

#define NJAPPNAME PACKAGE " " VERSION

/* Also in lib/njamd.h */
#ifndef HAVE_VSNPRINTF
# define vsnprintf(s, n, f, ap)			vsprintf(s, f, ap)
#endif

#ifndef HAVE_SNPRINTF
# define snprintf(s, n, f, ap...)		sprintf(s, f, ## ap)
#endif

#endif /* __NJAMD_NJAMD_H__ */
