/** 
 * @file libc_syms.h
 * Header for libc symbol resolution
 *
 * Copyright (C) 2000 by Mike Perry.
 * Distributed WITHOUT WARRANTY under the GPL. See COPYING for details.
 */
#ifndef __NJAMD_LIB_LIBC_H__
#define __NJAMD_LIB_LIBC_H__
#include <config.h>

struct nj_libc_syms
{
	void *libc_handle;
	void *pthread_handle;
};

int __nj_libc_syms_init(struct nj_libc_syms *);
void *__nj_libc_syms_resolve_libc(struct nj_libc_syms *, char *);
void *__nj_libc_syms_resolve_pthread(struct nj_libc_syms *, char *);
void __nj_libc_syms_fini(struct nj_libc_syms *);

#endif
// vim:ts=4

