#include <fe/njamd.h>
#include <fe/util/exec.h>
#include <fe/util/libcwrap.h>

pid_t njExecuteProgram(char* argv[], int* stdinfd, int* stdoutfd,
	int* stderrfd, char* libToPreload)
{
#define READ_END 0
#define WRITE_END 1

	char* exeName = NULL;
	pid_t child;
	int stdinPipes[2];
	int stdoutPipes[2];
	int stderrPipes[2];

	/* Create pipe pairs */
	njPipe(stdinPipes);
	njPipe(stdoutPipes);
	njPipe(stderrPipes);
		
	/* 
	 * index 0 is for reading, 1 is for writing, so we want to be
	 * able to write to stdin and read from stdout and stderr (ie,
	 * the opposite of the normal functionality)
	 */
	*stdinfd  = stdinPipes[WRITE_END];
	*stdoutfd = stdoutPipes[READ_END];
	*stderrfd = stderrPipes[READ_END];

	child = njFork();

	if (child == 0) {  /* child */
		char* argv0;

		/* set pipes for stdin, stdout, stderr */
		njClose(stdinPipes[WRITE_END]);
		njDup2(stdinPipes[READ_END], STDIN_FILENO);
		njClose(stdinPipes[READ_END]);

		njClose(stdoutPipes[READ_END]);
		njDup2(stdoutPipes[WRITE_END], STDOUT_FILENO);
		njClose(stdoutPipes[WRITE_END]);

		njClose(stderrPipes[READ_END]);
		njDup2(stderrPipes[WRITE_END], STDERR_FILENO);
		njClose(stderrPipes[WRITE_END]);

		if (libToPreload != NULL)
			njSetenv("LD_PRELOAD", libToPreload, 1);

		exeName = njStrdup(argv[0]);

		/* step past last slash when executing */
		if ((argv0 = strrchr(argv[0], '/')) != NULL)
			argv[0] = argv0 + 1;

		/*
		 * I would prefer to use execle or execve, but those don't parse
		 * PATH.  Hopefully the extra entries in the environment won't
		 * be bad (actually, stuff like USER, HOME, etc. might be very
		 * important).
		 */
		njExecvp(exeName, argv);
	}

	/* parent */

	njClose(stdinPipes[READ_END]);
	njClose(stdoutPipes[WRITE_END]);
	njClose(stderrPipes[WRITE_END]);

#undef READ_END
#undef WRITE_END

	return child;
}
