/**
 * @file portability.c Portability hacks
 *
 * Various global variable hacks that exists for portability or workaround 
 * reasons, or for backwards compatibility with old NJAMD, just so shit works.
 *
 * The goal should be to eliminate these global variables eventually.
 */

#include <lib/portability.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <lib/output.h>

int						__nj_anonfd = -1;
int						__nj_prot = PROT_NONE;
nj_addr_t				__nj_sbrk0;

/* These variables are defined for portability, if the PAGE_SIZE and friends
 * aren't available as compile time constants
 */
#ifndef NJ_PAGE_SIZE
# if defined(DEBUG) || defined(EDBUG)
#  warning "**** Page Size undefined ****"
# endif
u_long 					NJ_PAGE_SIZE;
#endif

#ifndef NJ_PAGE_MASK
u_long 					NJ_PAGE_MASK;
#endif

#ifndef NJ_PAGE_SHIFT
u_long 					NJ_PAGE_SHIFT;
#endif

/**
 * Porability init
 *
 * Does shit like setting up PAGE_SIZE if they don't exist, setting up mapping 
 * fds, finding the top of the heap for return address calc, etc */
void __nj_portability_bootstrap_init(void)
{
	struct stat st;
	int i;

	/* Workaround. If you have no permissions on your home directory and you
	 * call open this early, the program crashes mysteriously. Well, at least
	 * on glibc systems.. */
	stat("./", &st);

	i = geteuid();

	if(i != 0)
	{
		if(st.st_uid != i)
		{
			i = getegid();
			if(i != 0)
			{
				if(st.st_gid != i)
				{
					/* Directory world writable? */
					if(!(st.st_mode & S_IWOTH))
					{
						__nj_eprintf("Error: Permission denied on ./");
						_exit(1);
					}
				} /* Directory group writable? */
				else if(!(st.st_mode & S_IWGRP))
				{
					__nj_eprintf("Error: Permission denied on ./");
					_exit(1);
				}
			}
		} /* Directory user writable? */
		else if(!(st.st_mode & S_IWUSR))
		{
			__nj_eprintf("Error: Permission denied on ./");
			_exit(1);
		}
	}

#ifndef NJ_PAGE_SIZE
	NJ_PAGE_SIZE = getpagesize();
	if((i = open("/dev/zero", O_RDONLY)) == -1)
	{
		__nj_perror("open");
		_exit(1);		
	}

	if((__nj_zero_page = mmap(NULL, NJ_PAGE_SIZE, PROT_READ, MAP_PRIVATE, i,
					0)) == -1)
	{
		__nj_perror("Mapping zero page");
		_exit(1);
	}
	close(i);
#endif

#ifndef NJ_PAGE_MASK
	NJ_PAGE_MASK = ~(NJ_PAGE_SIZE-1);
#endif

#ifndef NJ_PAGE_SHIFT
	for(i=0; i < sizeof(u_long)*8; i++)
	{
		if(NJ_PAGE_SIZE & (1<<i))
		{
			NJ_PAGE_SHIFT = i;
			break;
		}
	}
#endif

	TR;
	/* We do a little trick to save on dozens of ifdefs. mmaps that support
	 * anonymous mappings expect the fd to be -1. Those that don't expect no
	 * MAP_ANON flag and the fd to be /dev/zero for anonymous memory.
	 * Note: Some OS's (Linux especially) PREFAULT memory from /dev/zero,
	 * thats why we can't use it all the time.
	 */
	if(!MAP_ANON && (__nj_anonfd = open("/dev/zero", O_RDWR)) == -1)
	{
		__nj_perror("open");
		_exit(1);		
	}
	__nj_sbrk0 = (nj_addr_t)sbrk(0);
}

/**
 * User portability hack
 *
 * The only thing this guy does is set the prot to port read if the user
 * requests it.
 */
void __nj_portability_user_init(struct nj_prefs *prefs)
{

	/** prot_read started out as a portability issue with glibc.. I guess
	 * you could make a fair argument for it being a user pref.. The best 
	 * thing to do would be to autoconf for it.. but MAN would that be a bitch
	 */
	if(prefs->stat.allow_read)
		__nj_prot = PROT_READ;
	
}

/**
 * Does nothing
 */
void __nj_portability_fini(void)
{
	return;
}


// vim:ts=4
