#! /usr/bin/perl -w                                                             
# $Header: /cvsroot/njamd/njamd/tests/run_tests.pl,v 1.1.1.1 2000/09/27 07:07:48 mikepery Exp $   
                                                                                
# Wrapper script for `make check' in tests/ for njamd                           
#       (see http://fscked.org/proj/njamd.shtml)                                
                                                                                
$README         = "README";     # file to find expected results                 
$PASSFAIL       = "PASS|FAIL";  # regexp for test results                       
$prot           = "NJAMD_PROT"; # Env Var defining which PROT to use            
$chk            = "NJAMD_CHK_FREE"; # Env Var defining whether to check free    
$chk_val        = "error";       # set NJAMD_CHK_FREE to none for testing        
$sep            = "-";          # Internal separator                            
$first          = 1;            # Is this the first set of test results ?       
$cmd            = "make check 2> /dev/null|"; # command to generate results     
                                                                                
# Open the file which defines the expected results and possible PROTs    
open(README, $README) || die("$0: Failed to open $README: $!\n");               
while (<README>) {                                                              
        chomp;                                                                  
        @LAST = @F;     # Remember the line before the first test results       
        @F = split;                                                             
        next unless $#F > 4;                                                    
        if ($F[1] =~ /$PASSFAIL/o && $F[1] =~ /$PASSFAIL/o) {                   
                if ($first) {   # process the column headers to get PROTs       
                        $first = $i = 0;                                        
                        while ($id = shift @LAST) { $x[$i]=$id;$mode{$id}=$i++} 
                }                                                               
                $type{$type = shift @F} = 1;                                    
                foreach $i (0 .. $#F) { $expect{"$type$sep$i"} = shift @F; }    
        }                                                                       
}                                                                               
close(README) || die("$0: Failed to close $README: $!\n");                      
                                                                                
# Use explicit command line args, Env Vars if set, otherwise do them all.       
if ($#ARGV >= 0) { while ($arg = shift) { &check($arg); } }                     
elsif ($ENV{$prot}) { &check($ENV{$prot}, $ENV{$chk}); }                  
else { foreach $i (0 .. $#x) { &check($i) } }                                   
                                                                                
# Check a particular mode.                                                      
sub check {                                                                     
        $mode   = $_[0];                                                        
        $chck   = $_[1] || "segv";                                                  
                                                                                
        # Accept numeric value or name.                                         
        if ($mode =~ /^\d+$/) {                                                 
                $mode = $x[($moden = $mode) & ~1];                              
                $chck = $chk_val if $i % 2;                                        
        } else { $moden = $mode{$mode}; }                                       
        die("$0: unknown mode '$mode'/'$moden'\n") unless defined $moden&&$mode;
                                                                                
        # Set the environment variables.                                        
        $ENV{$prot} = $mode; $ENV{$chk} = $chck;                                
        printf "\nUsing %-10s\tExpected\tActual\n", "$ENV{$prot}:$ENV{$chk}";                   
        print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
        open(CMD, $cmd) || die("$0: Failed to open $cmd: $!\n");                
        while (<CMD>) {                                                         
                chomp; @F = split;                                              
               next unless $#F == 1 && $type{$F[1]};                           
                $F[0] =~ s/:$//;                                                
                printf "%-20s\t %-8s\t %-6s%s\n", $F[1],                    
                        $expect{"$F[1]$sep$moden"}, $F[0],                            
                        ($F[0] eq $expect{"$F[1]$sep$moden"}) ? "" :            
                                " <<=== WRONG";                                 
        }                                                                       
        unless (close(CMD)) {                                                   
                print "$0: Failed ($?) to close $cmd: $!\n" unless $? == 512;
        }         
}
