#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <libnjb.h>

void usage (void);

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	u_int32_t id;
	int i, n, debug, syntax, opt;
	extern int optind;
	extern char *optarg;
	char *endptr;
	unsigned long *ids;

	debug= syntax= 0;

	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			usage();
		}
	}
	argc-= optind;
	argv+= optind;

	if ( argc < 1 ) usage();

	ids = (unsigned long *)malloc(argc*sizeof(unsigned long));

	for (i=0;i<argc;i++) {
		id= strtoul(argv[i], &endptr, 10);
		if ( endptr[0] != '\0' ) {
			fprintf(stderr, "XXX invalid track id %s\n", argv[i]);
			return 1;
		}
		ids[i] = id;
	}

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
	}
	if ( n == 0 ) {
		fprintf(stderr, "XXX no NJB devices found\n");
		return 0;
	}

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	for (i=0;i<argc;i++) {
		id = ids[i];
		if ( NJB_Delete_Track(njb, id) == -1 ) {
			njb_error_dump(stderr);
		}
	}

	NJB_Release(njb);

	NJB_Close(njb);

	return 0;
}

void usage (void)
{
	fprintf(stderr, "usage: njbdeletetrack [ -D debuglvl ] <trackid> [<trackid>...]\n");
	exit(1);
}
