/* Argument processing and getfields() taken from Plan 9's u9fs.
 * These routines were modified to be ASCII only and  were extended
 * to do something half sensible with --gnu-silly-options.
 *
 * The authors of this software are Russ Cox, Sean Dorward, Eric Grosse, et al.
 * Copyright (c) 2002 by Lucent Technologies.
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, provided that this entire notice
 * is included in all copies of any software which is or includes a copy
 * or modification of this software and in all copies of the supporting
 * documentation for such software.
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR LUCENT MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
extern char *argv0;
#define	ARGBEGIN	for((void)(argv0||(argv0=*argv)),argv++,argc--;\
			    argv[0] && argv[0][0]=='-' && argv[0][1];\
			    argc--, argv++) {\
				char *_args, *_argt;\
				char _argc;\
				_args = &argv[0][1];\
				if(_args[0]=='-') {\
					if(_args[1]==0){\
						argc--; argv++; break;\
					} else {\
						_args++;\
						_args[1]=0;\
					}\
				}\
				_argc = 0;\
				while(*_args && (_argc = *_args++))\
				switch(_argc)
#define	ARGEND		SET(_argt);USED(_argt);USED(_argc);USED(_args);}\
					USED(argv);USED(argc);
#define	ARGF()		(_argt=_args, _args="",\
				(*_argt? _argt: argv[1]? (argc--, *++argv): 0))
#define	EARGF(x)		(_argt=_args, _args="",\
				(*_argt? _argt: argv[1]? (argc--, *++argv): ((x), abort(), (char*)0)))

#define	ARGC()		_argc

#define	SET(x)	(x) = 0
#define	USED(x)	(void)(x)

extern	int	getfields(char *, char **, int, int, char *);

#define	nelem(a)	(sizeof(a)/sizeof((a)[0]))

/* End Plan 9 stuff. */

extern	void	warn(char*, ...);
extern	void	fatal(char*, ...);
extern	void*	emalloc(int);
extern	void*	erealloc(void*, int);
extern	char*	estrdup(const char*);
extern	FILE*	efopen(const char*, const char*);
extern	FILE*	efreopen(const char*, const char*, FILE*);
extern	char*	frdstr(FILE*, char, int);

typedef struct {
	char**	list;
	char**	p;
	char**	e;
} Strlist;

#define	sl2vec(l)	((l)->list)
#define	sllen(l)	((l)->p - (l)->list)

extern	Strlist*	strlist(void);
extern	Strlist*	strlistn(int);
extern	void		slfree(Strlist*);
extern	void		slappend(Strlist*, char*);
