/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */


#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include "RCX_Log.h"
#include "RCX_Link.h"

#define VERSION "1.0 b4"

void PrintUsage();
int ProcessCommandLine(int argc, char **argv);
void PrintError(RCX_Result error);

static char *sTestArgs[]={"rcxlog"};

RCX_Link gLink;
const char *gSerialPort = nil;

int main(int argc, char **argv)
{
	RCX_Result result;
	RCX_Log log;
	int i;
	
	if (argc == 0)
	{
		argv = sTestArgs;
		argc = sizeof(sTestArgs) / sizeof(char *);
	}

	if (!ProcessCommandLine(argc, argv))
	{
		PrintUsage();
		return -1;
	}

	result = gLink.Open(gSerialPort);
	if (result >=0)
		result = log.Upload(&gLink);
	gLink.Close();

	if (result < 0)
	{
		PrintError(result);
		return -1;
	}
	
	for(i=0; i<log.GetLength(); i++)
	{
		printf("%d\n", log.GetData(i));
	}
	
	return 0;
}


void PrintError(RCX_Result error)
{
	switch(error)
	{
		case kRCX_OpenSerialError:
			fprintf(stderr, "Could not open serial port\n");
			break;
		case kRCX_IREchoError:
			fprintf(stderr, "Problem talking to IR device\n");
			break;
		case kRCX_ReplyError:
			fprintf(stderr, "No reply from RCX\n");
			break;
		default:
			fprintf(stderr, "Error #%d\n", -error);
			break;
	}
}


void PrintUsage()
{
	fprintf(stderr,"rcxlog version "VERSION" (built "__DATE__"," __TIME__")\n");
	fprintf(stderr,"     written by Dave Baum\n");
	fprintf(stderr,"Usage: rcxlog [-s serial_port]\n");
}


int ProcessCommandLine(int argc, char **argv)
{
	int v;
	
	for(int i=1; i<argc; i++)
	{
		if (argv[i][0]=='-')
		{
			switch(tolower(argv[i][1]))
			{
				case 's':
					i++;
					if (i==argc || gSerialPort) return 0;
					gSerialPort = argv[i];
					break;
				case 't':
					i++;
					if (i==argc) return 0;
					v = atoi(argv[i]);
					gLink.SetRxTimeout(v);
					break;
				case 'v':
					gLink.SetVerbose(true);
					break;
				default:
					return 0;
			}
		}
		else
			return 0;
	}
	
	return 1;
}
