/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 2000 David Baum.
 * All Rights Reserved.
 */

#include "BinaryBaseExpr.h"

BinaryBaseExpr::BinaryBaseExpr(Expr *lhs, Expr *rhs)
	: Expr(rhs->GetLoc()), fLeft(lhs), fRight(rhs)
{
}


BinaryBaseExpr::~BinaryBaseExpr()
{
	delete fLeft;
	delete fRight;
}


bool BinaryBaseExpr::PromiseConstant() const
{
	return fLeft->PromiseConstant() && fRight->PromiseConstant();
}


bool BinaryBaseExpr::Contains(int var) const
{
	return fLeft->Contains(var) || fRight->Contains(var);
}


bool BinaryBaseExpr::EmitSide_(Bytecode &b) const
{
	return fLeft->EmitSide(b) && fRight->EmitSide(b);
}


void BinaryBaseExpr::GetExprs(vector<Expr*> &v) const
{
	v.push_back(fLeft);
	v.push_back(fRight);
}
