/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#ifndef __Conditional_h
#define __Conditional_h

#ifndef __PListS_h
#include "PListS.h"
#endif

class Conditional
{
public:
			Conditional();
			~Conditional();

	bool	IsActive()		{ return (GetLevel()->fState == Level::kActive) ? true : false; }
	bool	IsTopLevel()	{ return GetLevel()->fTopLevel; }
	
	void	If(bool b);
	bool	Elif(bool b);
	bool	Else();
	bool	Endif();

private:
	class Level : public PLinkS<Level>
	{
	public:
		// states for a level
		enum State
		{
			kInactive,
			kActive,
			kPending
		};

		State	fState;			// see above
		bool	fElseAllowed;	// true until else is done
		bool	fTopLevel;		// only true for the top level
	};

	Level*	GetLevel()		{ return fLevels.GetHead(); }

	PListSS<Level>	fLevels;
};


#endif
