/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "Fragment.h"
#include "BlockStmt.h"
#include "RCX_Cmd.h"
#include "Bytecode.h"
#include "Program.h"
#include "Symbol.h"
#include "CallStmt.h"
#include "DeclareStmt.h"
#include "TaskIdExpr.h"

#ifdef DEBUG
// uncomment this to print the statement tree
//#define DEBUG_DUMP_FRAGMENT
#endif


Fragment::Fragment(RCX_FragmentType type, Symbol *name, Stmt *body)
{
	fType = type;
	fName = name;
	fBody = body;

	if (fType == kRCX_TaskFragment)
	{
		if (name == Symbol::Get("main"))
			fNumber = gProgram->AddMainTask(this);
		else
			fNumber = gProgram->AddTask(this);
		fTaskID = fNumber;
	}
	else
	{
		fNumber = gProgram->AddSubroutine(this);
		fTaskID = kNoTaskID;
	}
}


Fragment::~Fragment()
{
	delete fBody;
}


void Fragment::AssignTaskID(int n)
{
	if (n == fTaskID) return;
	
	if (fTaskID == kNoTaskID)
		fTaskID = n;
	else
		fTaskID = kMultiTaskID;
}


void Fragment::Emit(Bytecode &b)
{
	// bind TaskIdExprs to the actual task id
	// this must be done in Emit() rather than
	// Check() since subroutine trace isn't
	// complete until all fragments are checked
	TaskIdExpr::Patcher p(fTaskID);
	Apply(fBody, p);

	int rLabel = b.PushFlow(Bytecode::kReturnFlow);
	
	fBody->Emit(b);
	
	b.SetLabel(rLabel);
	b.PopFlow(Bytecode::kReturnFlow);
	
	b.ApplyFixups();
}



void Fragment::Check()
{
#ifdef DEBUG_DUMP_FRAGMENT
	DumpStmt(fBody);
#endif

	CallStmt::Expander e(this);
	Apply(fBody, e);	

	DeclareStmt::Binder b(0);
	Apply(fBody, b);
	
	fBody->ComputeNullable();
}

