/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "textdialog.h"
#include "localization.h"
#include "resource.h"
#include "config.h"

NedTextDialog::NedTextDialog(GtkWindow *parent, char *text,  unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume, gchar *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight) :
	m_tempo(tempo), m_volume(volume), m_enable_tempo(enable_tempo), m_enable_volume(enable_volume), m_text(text), m_font_family(font_family), m_font_size(font_size), m_font_slant(font_slant), m_font_weight(font_weight) {
	GtkWidget *dialog;
	GtkWidget *text_frame;
	GtkWidget *font_vbox;
	GtkWidget *volume_frame;
	GtkWidget *volume_hbox;
	GtkWidget *tempo_frame;
	GtkWidget *tempo_hbox;
	char *fontstring;
	PangoFontDescription *f_descr;
	PangoStyle pstyle = PANGO_STYLE_NORMAL;
	PangoWeight pwidth = PANGO_WEIGHT_NORMAL;

	dialog = gtk_dialog_new_with_buttons(_("Text"), parent, (GtkDialogFlags) (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
		GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
	g_signal_connect(dialog, "response", G_CALLBACK (CloseCallBack), (void *) this);

	f_descr = pango_font_description_new();
	pango_font_description_set_family(f_descr, m_font_family);
	switch (font_slant) {
		case CAIRO_FONT_SLANT_NORMAL: pstyle = PANGO_STYLE_NORMAL; break;
		case CAIRO_FONT_SLANT_ITALIC: pstyle = PANGO_STYLE_ITALIC; break;
		case CAIRO_FONT_SLANT_OBLIQUE: pstyle = PANGO_STYLE_OBLIQUE; break;
	}
	pango_font_description_set_style(f_descr, pstyle);

	switch (font_weight) {
		case CAIRO_FONT_WEIGHT_NORMAL: pwidth = PANGO_WEIGHT_NORMAL; break;
		case CAIRO_FONT_WEIGHT_BOLD:  pwidth = PANGO_WEIGHT_BOLD; break;
	}

	pango_font_description_set_weight(f_descr, pwidth);

	pango_font_description_set_size(f_descr, (int) (PS_ZOOM * font_size * 1024));
	 
	fontstring = pango_font_description_to_string(f_descr);
	

	text_frame = gtk_frame_new(_("text"));
	m_text_widget = gtk_entry_new_with_max_length(50);
	if (m_text != NULL) {
		gtk_entry_set_text(GTK_ENTRY(m_text_widget), m_text);
	}

	m_font_button = gtk_font_button_new_with_font(fontstring);
	g_free(fontstring);
	pango_font_description_free(f_descr);
	gtk_font_button_set_title(GTK_FONT_BUTTON(m_font_button), _("select font"));
	font_vbox =  gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(font_vbox), m_text_widget, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(font_vbox), m_font_button, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(text_frame), font_vbox);
	g_signal_connect(m_font_button, "font-set", G_CALLBACK(FontCallBack), (void *) this);

	volume_frame = gtk_frame_new(_("volume"));
	volume_hbox = gtk_hbox_new(FALSE, 2);

	m_volume_spin_box = gtk_spin_button_new_with_range (0.0, 127.0, 1.0);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(m_volume_spin_box), volume);
	gtk_widget_set_sensitive(m_volume_spin_box, m_enable_volume);

	m_check_volume = gtk_check_button_new_with_label(_("enable volume change"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_check_volume), m_enable_volume);
	gtk_box_pack_start(GTK_BOX(volume_hbox), m_check_volume, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(volume_hbox), m_volume_spin_box, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(volume_frame), volume_hbox);
	g_signal_connect(m_check_volume, "toggled", G_CALLBACK(VolumeToggled), (void *) this);


	tempo_frame = gtk_frame_new(_("tempo"));
	tempo_hbox = gtk_hbox_new(FALSE, 2);
	m_tempo_spin_box = gtk_spin_button_new_with_range (10.0, 999.0, 1.0);
	gtk_widget_set_sensitive(m_tempo_spin_box, m_enable_tempo);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(m_tempo_spin_box), tempo);
	m_check_tempo = gtk_check_button_new_with_label(_("enable tempo change"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_check_tempo), m_enable_tempo);
	gtk_box_pack_start(GTK_BOX(tempo_hbox), m_check_tempo, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tempo_hbox), m_tempo_spin_box, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(tempo_frame), tempo_hbox);
	g_signal_connect(m_check_tempo, "toggled", G_CALLBACK(TempoToggled), (void *) this);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), text_frame);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), volume_frame);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), tempo_frame);
	gtk_widget_show_all (dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));
}

void NedTextDialog::CloseCallBack(GtkDialog *dialog, gint result, gpointer data) {
	NedTextDialog *text_dialog = (NedTextDialog *) data;
	const gchar *newtext;

	switch (result) {
		case GTK_RESPONSE_ACCEPT:
			text_dialog->m_state = TRUE;
		break;
		default:
			text_dialog->m_state = FALSE;
		break;
	}
	if (text_dialog->m_state) {
		free(text_dialog->m_text);
		text_dialog->m_text = NULL;
		newtext = gtk_entry_get_text(GTK_ENTRY(text_dialog->m_text_widget));
		if (strlen(newtext) > 0) {
			text_dialog->m_text = strdup(newtext);
		}
		text_dialog->m_enable_tempo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(text_dialog->m_check_tempo));
		text_dialog->m_enable_volume = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(text_dialog->m_check_volume));
		text_dialog->m_volume = (int) (gtk_spin_button_get_value(GTK_SPIN_BUTTON(text_dialog->m_volume_spin_box)) + 0.4);
		text_dialog->m_tempo = (unsigned int) (gtk_spin_button_get_value(GTK_SPIN_BUTTON(text_dialog->m_tempo_spin_box)) + 0.4);
	}
	gtk_widget_destroy (GTK_WIDGET(dialog));
}

void NedTextDialog::getValues(bool *state, char **text, unsigned int *tempo, bool *enable_tempo, unsigned int *volume, bool *enable_volume, gchar **font_family, double *font_size, cairo_font_slant_t *font_slant, cairo_font_weight_t *font_weight) {
	*state = m_state;
	*text = m_text;
	*font_family = m_font_family;
	*font_size = m_font_size;
	*font_slant = m_font_slant;
	*font_weight = m_font_weight;
	*tempo = m_tempo;
	*volume = m_volume;
	*enable_tempo = m_enable_tempo;
	*enable_volume = m_enable_volume;
}

void NedTextDialog::FontCallBack(GtkButton *button, gpointer data) {
	NedTextDialog *text_dialog = (NedTextDialog *) data;
	gchar *fontname;
	PangoFontDescription* f_descr;
	PangoStyle pstyle;
	PangoWeight pweight;


	g_object_get(text_dialog->m_font_button, "font-name", &fontname, NULL);
	f_descr = pango_font_description_from_string(fontname);
	if (text_dialog->m_font_family != NULL) {
		g_free(text_dialog->m_font_family);
	}
	text_dialog->m_font_family = (gchar *) pango_font_description_get_family(f_descr);
	text_dialog->m_font_size = pango_font_description_get_size(f_descr) / 1024;
	text_dialog->m_font_size /= PS_ZOOM;
	pstyle = pango_font_description_get_style(f_descr);
	switch (pstyle) {
		case PANGO_STYLE_NORMAL: text_dialog->m_font_slant = CAIRO_FONT_SLANT_NORMAL; break;
		case PANGO_STYLE_OBLIQUE: text_dialog->m_font_slant = CAIRO_FONT_SLANT_OBLIQUE; break;
		case PANGO_STYLE_ITALIC: text_dialog->m_font_slant = CAIRO_FONT_SLANT_ITALIC; break;
		default: text_dialog->m_font_slant = CAIRO_FONT_SLANT_NORMAL; break;
	}
	pweight = pango_font_description_get_weight(f_descr);
	switch (pweight) {
		case PANGO_WEIGHT_BOLD: 
		case PANGO_WEIGHT_ULTRABOLD: 
		case PANGO_WEIGHT_HEAVY: text_dialog->m_font_weight = CAIRO_FONT_WEIGHT_BOLD; break;
		default: text_dialog->m_font_weight = CAIRO_FONT_WEIGHT_NORMAL; break;
	}
	

	g_free (fontname);
}

void NedTextDialog::TempoToggled(GtkToggleButton *button, gpointer data) {
	NedTextDialog *text_dialog = (NedTextDialog *) data;

	gtk_widget_set_sensitive(text_dialog->m_tempo_spin_box, gtk_toggle_button_get_active(button));
}

void NedTextDialog::VolumeToggled(GtkToggleButton *button, gpointer data) {
	NedTextDialog *text_dialog = (NedTextDialog *) data;

	gtk_widget_set_sensitive(text_dialog->m_volume_spin_box, gtk_toggle_button_get_active(button));
}
