#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright(C) 2007 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: info.py 11411 2007-11-30 16:02:21Z romain $
"""

from inl import InfoBase

class PacketInfo(InfoBase):
    """ Get informations on ONE packet """

    def __init__(self, table):
        InfoBase.__init__(self, table,
                              ['id', 'username', 'user_id', 'timestamp', 'oob_time_usec', 'oob_in', 'oob_out', 'oob_prefix',
                               'oob_mark', 'ip_saddr', 'ip_daddr', 'ip_tos', 'ip_ttl', 'ip_totlen', 'ip_ihl', 'ip_csum',
                               'ip_id', 'proto', 'sport', 'dport', 'tcp_seq', 'tcp_ackseq', 'tcp_window', 'tcp_urg',
                               'tcp_urgp', 'tcp_ack', 'tcp_psh', 'tcp_rst', 'tcp_syn', 'tcp_fin', 'udp_len',
                               'icmp_type', 'icmp_code', 'client_os', 'client_app', 'bytes_in', 'bytes_out',
                               'packets_in', 'packets_out', 'raw_mac']
                    )

    def entry_form(self, entry):
        """ We transform IP form to a string
            @param entry [tuple]
            @return [tuple]
        """

        """ id, username, user_id, timestamp, oob_time_usec, oob_in, oob_out, oob_prefix, oob_mark, ip_saddr,
            ip_daddr, ...
        """
        result = ()
        result += entry[:9]
        result += (self.ip2str(entry[9]),)
        result += (self.ip2str(entry[10]),)
        result += entry[11:]
        return result

    def __call__(self, **args):
        """
            @param id [integer] Packet ID
        """
        self._arg_int(args, 'id')

        # Used for see packets in archives. (InfoBase will see at args['begin'] and args['end'])
        for name in ('begin', 'end'):
            try:
                self.args[name] = int(args[name])
            except:
                pass

        result = self._sql_query("get_packet", self.args['id'])

        result.addCallback(self._print_result)
        return result
