#!/usr/bin/perl
#
# $Id: IPPacketHandler.pm,v 1.1 2001/10/06 22:19:14 levine Exp $
#
# Copyright (C) 2001  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################


#
# A base class PacketHandler for IP traffic.  

use NWatch::PacketHandler;
use PortScan::ScannedHost;
use PortScan::ScanSet;

use strict;

package NWatch::IPPacketHandler;

@NWatch::IPStatefulPH::ISA = qw( NWatch::PacketHandler );

sub new
{
    my( $type, $template_scanset, $accept_any_host ) = @_;
    my $self = NWatch::PacketHandler::new( $type );

    $self->{ output_scanset } = undef;  
    $self->{template_scanset} = $template_scanset;
    $self->{accept_any_host} = $accept_any_host;

    bless $self, $type;

    $self;
}

sub template_scanset { $_[0]->{template_scanset}; }
sub accept_any_host { $_[0]->{accept_any_host}; }

sub set_or_get
{
    my $field = shift;
    my $self = shift;
    my $val = shift;

    $self->{$field} = $val if defined $val;

    return $self->{$field};
}

sub output_scanset { return set_or_get( 'output_scanset' , @_ ); }












