/*
 * nzb
 *
 * Copyright (C) 2004-2006 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: output.h,v 1.3 2005/09/08 21:43:33 mnordstr Exp $
 *   This file provides the output functions.
 */


#ifndef OUTPUT_H
#define OUTPUT_H

#include <QtCore>
#include <QtNetwork>

#include "nzbdata.h"

class DetachedPlayer;

class Output : public QThread
{
	Q_OBJECT
public:
	Output(NzbList *nzblist, int thread_id, QMutex *file_lock, QObject *parent = 0);
	void run();
	void setStream(bool stream) { this->stream = stream; }
	
signals:
	void outputEvent(QString message, int type = 0);

public slots:
	void process();
	void stop();
	
private slots:
	void newConnection();
	void closeStream();
	
private:
	bool getNext(int *file, int *seg);
	void writeOut(int file, int seg);
	bool stream;
	QFile *fout;
	QObject *parent;
	NzbList *nzblist;
	int thread_id;
	QMutex *file_lock;
	int file, seg;
	
	QTcpServer *streamer;
	QTcpSocket *ms;
	QProcess *mp;
	DetachedPlayer *player;
};

class DetachedPlayer : public QThread
{
	Q_OBJECT
public:
	DetachedPlayer(QString cmd) { this->cmd = cmd; }
	void run();
	
private:
	QString cmd;
};

#endif
