(* ocamlgsl - OCaml interface to GSL                        *)
(* Copyright (©) 2002-2005 - Olivier Andrieu                *)
(* distributed under the terms of the GPL version 2         *)

(** Eigensystems *)

open Gsl_vectmat

type symm_ws
val make_symm_ws : int -> symm_ws

external _symm : mat -> vec -> symm_ws -> unit
    = "ml_gsl_eigen_symm"

val symm : 
  ?protect:bool ->
  [< `M of Gsl_matrix.matrix
   | `MF of Gsl_matrix_flat.matrix
   | `A of float array * int * int
   | `AA of float array array] ->
  Gsl_vector.vector

type symmv_ws
val make_symmv_ws : int -> symmv_ws

external _symmv : mat -> vec -> mat -> symmv_ws -> unit
    = "ml_gsl_eigen_symmv"

val symmv : 
  ?protect:bool ->
  [< `M of Gsl_matrix.matrix
   | `MF of Gsl_matrix_flat.matrix
   | `A of float array * int * int
   | `AA of float array array] ->
  Gsl_vector.vector * Gsl_matrix.matrix


type sort =
  | VAL_ASC
  | VAL_DESC
  | ABS_ASC
  | ABS_DESC

external symmv_sort : Gsl_vector.vector * Gsl_matrix.matrix -> sort -> unit
    = "ml_gsl_eigen_symmv_sort"


type herm_ws
val make_herm_ws : int -> herm_ws

external _herm : cmat -> vec -> herm_ws -> unit
    = "ml_gsl_eigen_herm"

val herm : 
  ?protect:bool ->
  [< `CM of Gsl_matrix_complex.matrix
   | `CMF of Gsl_matrix_complex_flat.matrix
   | `CA of Gsl_complex.complex_array * int * int ] -> 
  Gsl_vector.vector

type hermv_ws
val make_hermv_ws : int -> hermv_ws

external _hermv : cmat -> vec -> cmat -> hermv_ws -> unit
    = "ml_gsl_eigen_hermv"

val hermv : 
  ?protect:bool ->
  [< `CM of Gsl_matrix_complex.matrix
   | `CMF of Gsl_matrix_complex_flat.matrix
   | `CA of Gsl_complex.complex_array * int * int ] -> 
  Gsl_vector.vector * Gsl_matrix_complex.matrix

external hermv_sort : 
  Gsl_vector.vector * Gsl_matrix_complex.matrix -> 
    sort -> unit
    = "ml_gsl_eigen_hermv_sort"
