// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomConvert_ApproxCurve_HeaderFile
#define _GeomConvert_ApproxCurve_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom_Curve.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Geom_BSplineCurve.hxx>
#include <Standard_Real.hxx>
#include <GeomAbs_Shape.hxx>
#include <Standard_Integer.hxx>
#include <Standard_OStream.hxx>
class Geom_Curve;
class Geom_BSplineCurve;
class Standard_OutOfRange;
class Standard_ConstructionError;


//! A framework to convert a 3D curve to a 3D BSpline.
//! This is done by approximation to a BSpline curve within a given tolerance.
class GeomConvert_ApproxCurve 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs a curve approximation framework defined by -
  //! -      the conic Curve,
  //! -      the tolerance value Tol3d,
  //! -      the degree of continuity Order,
  //! -      the maximum number of segments
  //! MaxSegments allowed in the resulting BSpline curve, and
  //! -      the highest degree MaxDeg which the
  //! polynomial defining the BSpline curve may have.
  Standard_EXPORT GeomConvert_ApproxCurve(const Handle(Geom_Curve)& Curve, const Standard_Real Tol3d, const GeomAbs_Shape Order, const Standard_Integer MaxSegments, const Standard_Integer MaxDegree);
  
  //! Returns the BSpline curve resulting from the approximation algorithm.
  Standard_EXPORT   Handle(Geom_BSplineCurve) Curve()  const;
  
  //! returns  Standard_True  if  the  approximation  has
  //! been  done  within  requiered tolerance
  Standard_EXPORT   Standard_Boolean IsDone()  const;
  
  //! Returns  Standard_True if the approximation did come out
  //! with a result that  is not NECESSARELY within the required tolerance
  Standard_EXPORT   Standard_Boolean HasResult()  const;
  
  //! Returns the greatest distance between a point on the
  //! source conic and the BSpline curve resulting from the
  //! approximation. (>0 when an approximation
  //! has  been  done, 0  if  no  approximation)
  Standard_EXPORT   Standard_Real MaxError()  const;
  
  //! Print on the stream  o  information about the object
  Standard_EXPORT   void Dump (Standard_OStream& o)  const;




protected:





private:



  Handle(Geom_Curve) myCurve;
  Standard_Boolean myIsDone;
  Standard_Boolean myHasResult;
  Handle(Geom_BSplineCurve) myBSplCurve;
  Standard_Real myMaxError;


};







#endif // _GeomConvert_ApproxCurve_HeaderFile
