// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Aspect_MarkMapEntry_HeaderFile
#define _Aspect_MarkMapEntry_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Aspect_MarkerStyle_HeaderFile
#include <Aspect_MarkerStyle.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Aspect_BadAccess;
class Aspect_MarkerStyle;


//! This class defines a markmap entrys. <br>
//!	    A markmap entry is an association between <br>
//!	    a MarkerStyle object and an index in the markmap. <br>
class Aspect_MarkMapEntry  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates an unallocated markmap entry <br>
  Standard_EXPORT   Aspect_MarkMapEntry();
  //! Creates an allocated markmap entry <br>
  Standard_EXPORT   Aspect_MarkMapEntry(const Standard_Integer index,const Aspect_MarkerStyle& style);
  //! Creates an allocated markmap entry. <br>
//!  Warning: Raises error if the markmap entry <entry> <br>
//!	    is unallocated. <br>
  Standard_EXPORT   Aspect_MarkMapEntry(const Aspect_MarkMapEntry& entry);
  //! Sets markmap entry value and allocates it. <br>
  Standard_EXPORT     void SetValue(const Standard_Integer index,const Aspect_MarkerStyle& style) ;
  //! Sets markmap entry value and allocates it. <br>
  Standard_EXPORT     void SetValue(const Aspect_MarkMapEntry& entry) ;
    void operator =(const Aspect_MarkMapEntry& entry) 
{
  SetValue(entry);
}
  //! Sets the marker style of markmap entry. <br>
  Standard_EXPORT     void SetStyle(const Aspect_MarkerStyle& Style) ;
  
  Standard_EXPORT    const Aspect_MarkerStyle& Style() const;
  //! Sets index value of a markmap entry. <br>
  Standard_EXPORT     void SetIndex(const Standard_Integer index) ;
  //! Returns index value of a markmap entry. <br>
//!  Warning: Raises error if the markmap entry is unallocated . <br>
  Standard_EXPORT     Standard_Integer Index() const;
  //! Unallocates the markmap entry. <br>
  Standard_EXPORT     void Free() ;
  //! Returns True if the markmap entry is allocated. <br>
//!  Warning: A markmap entry is allocated when the marker and <br>
//!	    the index is defined. <br>
  Standard_EXPORT     Standard_Boolean IsAllocated() const;
  
  Standard_EXPORT     void Dump() const;





protected:





private:



Aspect_MarkerStyle MyStyle;
Standard_Integer MyIndex;
Standard_Boolean MyStyleIsDef;
Standard_Boolean MyIndexIsDef;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
