// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPTools_PaveBlock_HeaderFile
#define _BOPTools_PaveBlock_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_Pave_HeaderFile
#include <BOPTools_Pave.hxx>
#endif
#ifndef _IntTools_Range_HeaderFile
#include <IntTools_Range.hxx>
#endif
#ifndef _IntTools_ShrunkRange_HeaderFile
#include <IntTools_ShrunkRange.hxx>
#endif
#ifndef _IntTools_Curve_HeaderFile
#include <IntTools_Curve.hxx>
#endif
#ifndef _BOPTools_PointBetween_HeaderFile
#include <BOPTools_PointBetween.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class BOPTools_Pave;
class IntTools_ShrunkRange;
class BOPTools_PointBetween;
class IntTools_Curve;
class IntTools_Range;



//!  Class for storing info about a couple <br>
//! of neighbouring paves on an edge <br>
class BOPTools_PaveBlock  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//! Empty constructor <br>
  Standard_EXPORT   BOPTools_PaveBlock();
  
//! Constructor <br>
//! Index  - DS-index of the edge <br>
//! aPave1 - one pave <br>
//! aPave2 - other pave <br>
  Standard_EXPORT   BOPTools_PaveBlock(const Standard_Integer anEdge,const BOPTools_Pave& aPave1,const BOPTools_Pave& aPave2);
  
//! Modifier <br>
//! Sets DS-index for the edge that is between aPave1 and aPave2 <br>
  Standard_EXPORT     void SetEdge(const Standard_Integer anEdge) ;
  
//! Modifier <br>
//! Sets DS-index for the edge from which this pave block comes from <br>
  Standard_EXPORT     void SetOriginalEdge(const Standard_Integer anEdge) ;
  
//! Modifier <br>
  Standard_EXPORT     void SetPave1(const BOPTools_Pave& aPave) ;
  
//! Modifier <br>
  Standard_EXPORT     void SetPave2(const BOPTools_Pave& aPave) ;
  
//! Modifier <br>
//! Sets the Shrunk Range for the pave block <br>
  Standard_EXPORT     void SetShrunkRange(const IntTools_ShrunkRange& aSR) ;
  
//! Modifier <br>
//! Sets the point between the paves for the pave block <br>
  Standard_EXPORT     void SetPointBetween(const BOPTools_PointBetween& aP) ;
  
//! Modifier <br>
//! Sets the intersection curve to which the pave block belongs to <br>
  Standard_EXPORT     void SetCurve(const IntTools_Curve& aC) ;
  
//! Modifier <br>
//! Sets the DS-index of the first face <br>
  Standard_EXPORT     void SetFace1(const Standard_Integer nF1) ;
  
//! Modifier <br>
//! Sets the DS-index of the second face <br>
  Standard_EXPORT     void SetFace2(const Standard_Integer nF2) ;
  
//! Selector <br>
  Standard_EXPORT     Standard_Integer Edge() const;
  
//! Selector <br>
  Standard_EXPORT     Standard_Integer OriginalEdge() const;
  
//! Selector <br>
  Standard_EXPORT    const BOPTools_Pave& Pave1() const;
  
//! Selector <br>
  Standard_EXPORT    const BOPTools_Pave& Pave2() const;
  
//! Returns  TRUE if both paves have vertex index !=0 <br>
  Standard_EXPORT     Standard_Boolean IsValid() const;
  
//! Returns  TRUE if <Other> is  equal to me <br>
  Standard_EXPORT     Standard_Boolean IsEqual(const BOPTools_PaveBlock& Other) const;
  
//! Returns values for paves' parameters <br>
  Standard_EXPORT     void Parameters(Standard_Real& aT1,Standard_Real& aT2) const;
  
//! Returns parmetric range for paves' parameters <br>
  Standard_EXPORT    const IntTools_Range& Range() const;
  
//! Selector <br>
  Standard_EXPORT    const IntTools_ShrunkRange& ShrunkRange() const;
  
//! Selector <br>
  Standard_EXPORT    const BOPTools_PointBetween& PointBetween() const;
  
//! Selector <br>
  Standard_EXPORT    const IntTools_Curve& Curve() const;
  
//! Selector <br>
  Standard_EXPORT     Standard_Integer Face1() const;
  
//! Selector <br>
  Standard_EXPORT     Standard_Integer Face2() const;
  
  Standard_EXPORT     Standard_Boolean IsInBlock(const BOPTools_Pave& aPaveX) const;





protected:





private:



Standard_Integer myEdge;
Standard_Integer myOriginalEdge;
BOPTools_Pave myPave1;
BOPTools_Pave myPave2;
IntTools_Range myRange;
IntTools_ShrunkRange myShrunkRange;
IntTools_Curve myCurve;
Standard_Integer myFace1;
Standard_Integer myFace2;
BOPTools_PointBetween myPointBetween;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
