// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _HLRBRep_Intersector_HeaderFile
#define _HLRBRep_Intersector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _IntRes2d_IntersectionPoint_HeaderFile
#include <IntRes2d_IntersectionPoint.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _HLRBRep_CInter_HeaderFile
#include <HLRBRep_CInter.hxx>
#endif
#ifndef _HLRBRep_InterCSurf_HeaderFile
#include <HLRBRep_InterCSurf.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_UndefinedDerivative;
class gp_Lin;
class IntRes2d_IntersectionPoint;
class IntCurveSurface_IntersectionPoint;
class IntRes2d_IntersectionSegment;
class IntCurveSurface_IntersectionSegment;


//! The Intersector  computes 2D  intersections of the <br>
//!          projections of 3D curves. <br>
//! <br>
//!          It can also computes the intersection of a 3D line <br>
//!          and a surface. <br>
class HLRBRep_Intersector  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   HLRBRep_Intersector();
  //! Performs the auto  intersection  of  an edge. The <br>
//!          edge domain is cutted at start with da1*(b-a) and <br>
//!          at end with db1*(b-a). <br>
  Standard_EXPORT     void Perform(const Standard_Address A1,const Standard_Real da1,const Standard_Real db1) ;
  //! Performs the  intersection between the two edges. <br>
//!          The  edges  domains  are  cutted  at  start  with <br>
//!          da*(b-a) and at end with db*(b-a). <br>
  Standard_EXPORT     void Perform(const Standard_Integer nA,const Standard_Address A1,const Standard_Real da1,const Standard_Real db1,const Standard_Integer nB,const Standard_Address A2,const Standard_Real da2,const Standard_Real db2,const Standard_Boolean NoBound) ;
  //! Create a single IntersectionPoint (U on A1) (V on A2) <br>
//!          The point is middle on both curves. <br>
  Standard_EXPORT     void SimulateOnePoint(const Standard_Address A1,const Standard_Real U,const Standard_Address A2,const Standard_Real V) ;
  
  Standard_EXPORT     void Load(Standard_Address& A) ;
  
  Standard_EXPORT     void Perform(const gp_Lin& L,const Standard_Real P) ;
  
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
  Standard_EXPORT     Standard_Integer NbPoints() const;
  
  Standard_EXPORT    const IntRes2d_IntersectionPoint& Point(const Standard_Integer N) const;
  
  Standard_EXPORT    const IntCurveSurface_IntersectionPoint& CSPoint(const Standard_Integer N) const;
  
  Standard_EXPORT     Standard_Integer NbSegments() const;
  
  Standard_EXPORT    const IntRes2d_IntersectionSegment& Segment(const Standard_Integer N) const;
  
  Standard_EXPORT    const IntCurveSurface_IntersectionSegment& CSSegment(const Standard_Integer N) const;
  
  Standard_EXPORT     void Destroy() ;
~HLRBRep_Intersector()
{
  Destroy();
}





protected:





private:



IntRes2d_IntersectionPoint mySinglePoint;
Standard_Integer myTypePerform;
HLRBRep_CInter myIntersector;
HLRBRep_InterCSurf myCSIntersector;
Standard_Address mySurface;
Standard_Address myPolyhedron;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
