// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_ViewOrientation_HeaderFile
#define _Visual3d_ViewOrientation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Graphic3d_Vector_HeaderFile
#include <Graphic3d_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HArray2OfReal;
class Visual3d_ViewOrientationDefinitionError;
class Visual3d_View;
class Graphic3d_Vertex;
class Graphic3d_Vector;


//! This class allows the definition of the manner in <br>
//!	    which an observer looks at the visualised scene. <br>
//!	    It defines a coordinate system called VRC <br>
//!	    (View Reference Coordinates) with 3 axes U,V,N <br>
//! Summary of 3D View Orientation              -- <br>
//!                                             -- <br>
//! The view orientation transformation defines -- <br>
//! the relationship  between World Coordinates -- <br>
//! (WC) and  View Reference  Coordinates (VRC) -- <br>
//!                                             -- <br>
//! To define a view orientation transformation -- <br>
//! you must define :                           -- <br>
//!                                             -- <br>
//!	The View Reference Point (VRP)         -- <br>
//!	The View Plane Normal (VPN)            -- <br>
//!	The View Up Vector (VUP).              -- <br>
//! <br>
//! Optionally, it is possible to specify anisotropic <br>
//! (axial) scale factors. This allows to scale the scene <br>
//! using individual scale values along each coordinate axis. <br>
class Visual3d_ViewOrientation  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates a VRC coordinate system. <br>
//!	    VRP		: Origin of the VRC coordinate system. <br>
//!			  (default value : 0.0, 0.0, 0.0) <br>
//!	    VPN		: Vector normal to the plane of visualisation. <br>
//!			  (default value : 0.0, 0.0, 1.0) <br>
//!	    VUP 	: Vector for which the projection in the plane <br>
//!			  of visualisation defines the axis V of a VRC <br>
//!			  coordinate system. <br>
//!			  (default value : 0.0, 1.0, 0.0) <br>
  Standard_EXPORT   Visual3d_ViewOrientation();
  //! Creates a VRC coordinate system. <br>
//!	    VRP		: Origin of the VRC coordinate system. <br>
//!	    VPN		: Vector normal to the plane of visualisation. <br>
//!	    VUP 	: Vector for which the projection in the plane <br>
//!			  of visualisation defines the axis V of a VRC <br>
//!			  coordinate system. <br>
//!			  This vector can be likened to the <br>
//!			  vertical of the observer. <br>
//!  Warning: Raises ViewOrientationDefinitionError <br>
//!	    if <VPN> is null. <br>
//!	    if <VUP> is null. <br>
//!	    if <VPN> and <VUP> are parallel. <br>
  Standard_EXPORT   Visual3d_ViewOrientation(const Graphic3d_Vertex& VRP,const Graphic3d_Vector& VPN,const Graphic3d_Vector& VUP);
  //! Creates a VRC coordinate system. <br>
//!	    VRP		: Origin of VRC coordinate system. <br>
//!	    VPN		: Normal vector to the plane of visualisation. <br>
//!	    Twist 	: Angle in radians of the V axis in the VRC <br>
//!			  coordinate system with the projection in <br>
//!			  the plane of visualisation of the Zm axis <br>
//!			  in the model space. <br>
//!  Warning: Raises ViewOrientationDefinitionError if <VPN> is null. <br>
  Standard_EXPORT   Visual3d_ViewOrientation(const Graphic3d_Vertex& VRP,const Graphic3d_Vector& VPN,const Standard_Real Twist);
  //! Creates a VRC coordinate system. <br>
//!	    VRP		: Origin of the VRC coordinate system. <br>
//!	    Azim 	: Angle in radians of the plane of visualisation <br>
//!			  with the XmYm plane of the model space. <br>
//!	    Inc 	: Angle in radians of the plane of visualisation <br>
//!			  with the YmZm plane of the model space. <br>
//!	    Twist 	: Angle in radians of the V axis in the VRC <br>
//!			  coordinate system with the projection in <br>
//!			  the plane of visualisation of the Zm axis <br>
//!			  in the model space. <br>
//!  Warning: Raises ViewOrientationDefinitionError <br>
  Standard_EXPORT   Visual3d_ViewOrientation(const Graphic3d_Vertex& VRP,const Standard_Real Azim,const Standard_Real Inc,const Standard_Real Twist);
  //! Modifies the plane of visualisation <br>
//!	    defined by a normal vector. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewOrientationDefinitionError if <VPN> is null. <br>
  Standard_EXPORT     void SetViewReferencePlane(const Graphic3d_Vector& VPN) ;
  //! Modifies the origin of the VRC coordinate system <br>
  Standard_EXPORT     void SetViewReferencePoint(const Graphic3d_Vertex& VRP) ;
  //! Modifies the vertical of the observer. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewOrientationDefinitionError if <VUP> is null. <br>
  Standard_EXPORT     void SetViewReferenceUp(const Graphic3d_Vector& VUP) ;
  //! Sets axial scale factors of the view <br>
  Standard_EXPORT     void SetAxialScale(const Standard_Real Sx,const Standard_Real Sy,const Standard_Real Sz) ;
  //! Sets custom MODELVIEW matrix for the OpenGl context <br>
  Standard_EXPORT     void SetCustomModelViewMatrix(const Handle(TColStd_HArray2OfReal)& Mat) ;
  //! Returns the angle in radians of the V axis in the VRC <br>
//!	    coordinate system with the projection in the plane of <br>
//!	    visualisation of the Zm axis in the model space. <br>
  Standard_EXPORT     Standard_Real Twist() const;
  //! Returns the normal to the plane of projection. <br>
  Standard_EXPORT     Graphic3d_Vector ViewReferencePlane() const;
  //! Returns origin of the VRC coordinate system. <br>
  Standard_EXPORT     Graphic3d_Vertex ViewReferencePoint() const;
  //! Returns the vertical of the observer. <br>
  Standard_EXPORT     Graphic3d_Vector ViewReferenceUp() const;
  //! Returns current values of the axial scale factors. <br>
  Standard_EXPORT     void AxialScale(Standard_Real& Sx,Standard_Real& Sy,Standard_Real& Sz) const;
  //! Returns whether the custom MODELVIEW matrix is used. <br>
  Standard_EXPORT     Standard_Boolean IsCustomMatrix() const;


friend class Visual3d_View;



protected:





private:

  //! Copies the content of <Other> into <me>. <br>
  Standard_EXPORT     void Assign(const Visual3d_ViewOrientation& Other) ;


Graphic3d_Vertex MyViewReferencePoint;
Graphic3d_Vector MyViewPlaneNormal;
Graphic3d_Vector MyViewUpVector;
Standard_Real MyScaleX;
Standard_Real MyScaleY;
Standard_Real MyScaleZ;
Handle_TColStd_HArray2OfReal MyModelViewMatrix;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
