/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef PLUGINMODEL_H
#define PLUGINMODEL_H

#include <cstdlib>
#include <string>
using std::string;

namespace LibOmClient {


/** Model for a plugin available for loading.
 */
class PluginModel
{
public:
	PluginModel() {}

	/*PluginModel(const PluginModel& copy) {
		m_type = copy.m_type;
		m_lib_path = copy.m_lib_path;
		m_lib_name = copy.m_lib_name;
		m_plug_label = copy.m_plug_label;
		m_name = copy.m_name;
		m_handle = copy.m_handle;
	}*/

	enum Type { LADSPA, DSSI, Internal, Patch };
	
	Type          type() const                { return m_type; }
	void          type(Type t)                { m_type = t; }
	const string& lib_path() const            { return m_lib_path; }
	void          lib_path(const string& s)   { m_lib_path = s; }
	const string& lib_name() const            { return m_lib_name; }
	void          lib_name(const string& s)   { m_lib_name = s; }
	const string& plug_label() const          { return m_plug_label; }
	void          plug_label(const string& s) { m_plug_label = s; }
	const string& name() const                { return m_name; }
	void          name(const string& s)       { m_name = s; }
	
	const char* const type_string() const {
		if (m_type == LADSPA) return "LADSPA";
		else if (m_type == DSSI) return "DSSI";
		else if (m_type == Internal) return "Internal";
		else if (m_type == Patch) return "Patch";
		else return "";
	}

	void set_type(const string& type_string) {
		if (type_string == "LADSPA") m_type = LADSPA;
		else if (type_string == "DSSI") m_type = DSSI;
		else if (type_string == "Internal") m_type = Internal;
		else if (type_string == "Patch") m_type = Patch;
	}

private:
	// Prevent copies
	PluginModel(const PluginModel& copy)            { exit(EXIT_FAILURE); }
	PluginModel& operator=(const PluginModel& copy) { exit(EXIT_FAILURE); }
	
	Type   m_type;
	string m_lib_path;
	string m_lib_name;
	string m_plug_label;
	string m_name;
};


} // namespace Om

#endif // PLUGINMODEL_H

