/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef GTKCLIENTHOOKS_H
#define GTKCLIENTHOOKS_H

#include <string>
#include <queue>
#include "ClientHooks.h"
#include "Queue.h"
using std::string;// using std::queue;

namespace Om { class PluginModel; }

using namespace LibOmClient;

namespace OmGtk {

class Event;


/** ClientHooks implementation for the Gtk client.
 *
 * These are the hooks into the GUI for the Comm class.
 *
 * \ingroup OmGtk
 */
class GtkClientHooks : public ClientHooks
{
public:
	GtkClientHooks();
	virtual ~GtkClientHooks();
	
	void set_ignore_port(const string& path) { m_ignore_port_path = path; }
	void clear_ignore_port()                 { m_ignore_port_path = ""; }
	
	// OSC thread functions
	void error(const string& msg);
	
	void engine_enabled();
	void engine_disabled();
	void new_patch(PatchModel* const pm);
	void new_port(PortModel* const port_model);
	void port_removal(const string& path);
	void patch_destruction(const string& path);
	void patch_enabled(const string& path);
	void patch_disabled(const string& path);
	void new_node(NodeModel* const nm);
	void node_removal(const string& path);
	void object_renamed(const string& old_path, const string& new_path);
	void connection(ConnectionModel* const cm);
	void disconnection(const string& src_port_path, const string& dst_port_path);
	void metadata_update(MetadataModel* const mm);
	void control_change(ControlModel* const cm);
	void new_plugin(PluginModel* const pi);

	inline void push_event(Event* const ev);

	// Gtk thread function
	void process_events();

private:
	//pthread_mutex_t m_event_queue_mutex;

	/** Set if a port slider is grabbed and is being dragged.
	 * If a control event comes in for a port with this path, we'll just
	 * ignore it outright.  (Just an optimization over doing all the searching
	 * for the port slider just to ignore the event) */
	string m_ignore_port_path;

	Queue<Event*> m_events;
};


inline void
GtkClientHooks::push_event(Event* const ev)
{
	//try {
		m_events.push(ev);
	//} catch (QueueOverflowException e) {
	//	cerr << "[GtkClientHooks] Incoming event queue full - event is lost!  May be missing nodes, etc.";
	//}
}


} // namespace OmGtk

#endif // GTKCLIENTHOOKS_H
