/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OMGTKOBJECT_H
#define OMGTKOBJECT_H

namespace LibOmClient { class MetadataModel; }

namespace OmGtk {


/** Representation of an Om object - patch, port, or node (module).
 *
 * This is a common base class for the graphical classes that represent an
 * Om object - PatchController, OmModule, OmPort, etc.  Each of these will have
 * a Model class associated with it as well (NodeModel etc).
 *
 * \ingroup OmGtk
 */
class OmGtkObject {
public:
	virtual ~OmGtkObject() {}
	virtual void metadata_update(const LibOmClient::MetadataModel* const mm) = 0;
};


} // namespace OmGtk

#endif // OMGTKOBJECT_H
