/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DSSIPLUGIN_H
#define DSSIPLUGIN_H

#include <dssi.h>
#include <lo/lo.h>
#include "LADSPAPlugin.h"
#include "Om.h"
#include "AlsaDriver.h"

namespace Om {


/** An instance of a DSSI plugin.
 */
class DSSIPlugin : public LADSPAPlugin
{
public:
	DSSIPlugin(const string& name, uint poly, Patch* parent, DSSI_Descriptor* descriptor, samplerate srate, size_t buffer_size);
	~DSSIPlugin();

	void activate();

	void set_ui_url(const string& url);
	void send_update();

	void set_control(int port_num, sample val);
	void configure(const string& key, const string& val);
	void program(int bank, int program);

	void run(size_t nframes);

	const Plugin* const plugin() const  { return m_plugin; }
	void plugin(const Plugin* const pi) { m_plugin = pi; }

private:
	// Prevent copies
	DSSIPlugin(const DSSIPlugin& copy) : LADSPAPlugin(copy) { exit(EXIT_FAILURE); }
	DSSIPlugin& operator=(const DSSIPlugin& copy)           { exit(EXIT_FAILURE); }
	
	// DSSI GUI messages
	void send_control(int port_num, float value);
	void send_program(int bank, int value);
	void send_configure(const string& key, const string& val);
	void send_show();
	void send_hide();
	void send_quit();

	string     m_ui_url;
	string     m_ui_base_path;
	lo_address m_ui_addr;

	// Current values
	int                 m_bank;
	int                 m_program;
	map<string, string> m_configures;
	
	DSSI_Descriptor* m_dssi_descriptor;
};


} // namespace Om


#endif // DSSIPLUGIN_H

