/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DESTROYPATCHEVENT_H
#define DESTROYPATCHEVENT_H

#include "SlowEvent.h"
#include <string>
#include "List.h"
using std::string;

namespace Om {
	
class Patch;
class Node;
class TreeNode;
class Plugin;
class RemoveNodeEvent;


/** An event to remove and destroy a Patch.
 *
 * \ingroup engine
 */
class DestroyPatchEvent : public SlowEvent
{
public:
	DestroyPatchEvent(Request* request, const string& patch_path);
	DestroyPatchEvent(Patch* patch);
	~DestroyPatchEvent();

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string                   m_path;
	Patch*                   m_patch;
	RemoveNodeEvent*         m_remove_node_event;
	List<DestroyPatchEvent*> m_destroy_subpatch_events;
	bool                     m_lookup;
};


} // namespace Om


#endif // DESTROYPATCHEVENT_H
