/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef MIDICONTROLNODE_H
#define MIDICONTROLNODE_H


#include <string>
#include "NodeBase.h"
#include "InputPort.h"
#include "MidiInNode.h"
#include "MidiLearnEvent.h"

namespace Om {
	
using std::string;


/** MIDI control input node.
 *
 * Creating one of these nodes is how a user makes "MIDI Bindings".  Note that
 * this node will always be monophonic, the poly parameter is ignored.
 * 
 * \ingroup engine
 */
class MidiControlNode : public MidiInNode
{
public:
	MidiControlNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size);
	
	void control(int control_num, int val, int start_sample);

	void run(size_t nframes);

	friend class MidiLearnEvent;
	
private:
	// Disallow copies
	MidiControlNode(const MidiControlNode& copy) : MidiInNode(copy) { exit(EXIT_FAILURE); }
	MidiControlNode& operator=(const MidiControlNode& copy)         { exit(EXIT_FAILURE); }
	
	int  m_blocks_since_event;

	InputPort*  m_param_port;
	InputPort*  m_log_port;
	InputPort*  m_min_port;
	InputPort*  m_max_port;
	OutputPort* m_control_port;
	OutputPort* m_audio_port;
};


} // namespace Om

#endif // MIDICONTROLNODE_H
