/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OUTPUTNODE_H
#define OUTPUTNODE_H

#include <string>
#include "InternalNode.h"
#include "OutputPort.h"

using std::string;

namespace Om {

class Port;


/** A node to represent output ports on a patch
 *
 * A patch doesn't actually contain any ports, it's port accessor methods
 * directly return ports in this node.  This is why every port added to this
 * module really adds two port objects - one from the internal perspective (ie
 * a port on this node in a patch), and one from the external perspective (ie
 * a port on the patch itself (being a node as well).
 *
 * \ingroup engine
 */
class OutputNode : public InternalNode
{
public:
	virtual ~OutputNode() {}
	
	void set_name(const string& new_name) {
		InternalNode::set_name(new_name);
		m_external_port->set_name(new_name);
	}

	OutputPort* external_port() const { return m_external_port; }

protected:
	// Disallow copies
	OutputNode(const OutputNode& copy) : InternalNode(*this) { exit(EXIT_FAILURE); }
	OutputNode& operator=(const OutputNode& copy)            { exit(EXIT_FAILURE); }
	
	OutputNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size)
	: InternalNode(path, poly, parent, srate, buffer_size)
	{}

	ListNode<OutputNode*>* m_listnode;
	OutputPort*            m_external_port;
	// m_ports is used for internal_port
};


} // namespace Om

#endif // OUTPUTNODE_H
