(*
 * Basic utilities for the builtin functions.
 *
 * ----------------------------------------------------------------
 *
 * @begin[license]
 * Copyright (C) 2003 Jason Hickey, Caltech
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Jason Hickey
 * @email{jyh@cs.caltech.edu}
 * @end[license]
 *)
open Lm_symbol
open Lm_location

open Omake_env
open Omake_node
open Omake_build_type

(*
 * Add a command line variable definition.
 *)
val add_command_def : symbol -> string -> unit

(*
 * Check if there are command defs.
 *)
val command_defs_are_nonempty : unit -> bool

(*
 * Add all the command-line defs to the encironment.
 *)
val venv_add_command_defs : venv -> venv

(*
 * Map over a sequence and add separators.
 *)
val sequence_map : ('a -> value) -> 'a list -> value list
val sequence_list : value list -> value list

(*
 * Boolean values.
 *)
val val_true : value
val val_false : value

(*
 * Unfortunately, we have to specify the environment imperatively.
 *)
val set_env : env -> unit
val get_env : pos -> loc -> env

(*
 * A node is a leaf if it has no dependencies and no commands.
 *)
val is_leaf_command : command -> bool
val is_leaf_node    : env -> Node.t -> bool

(*
 * Get the object from a file.
 *)
val object_of_file : venv -> pos -> loc -> string -> obj

(*!
 * @docoff
 *
 * -*-
 * Local Variables:
 * Caml-master: "compile"
 * End:
 * -*-
 *)
