#! /bin/sh /usr/share/dpatch/dpatch-run
## 01_op_server.pl.dpatch by Alejandro Rios P. <alejandro.rios@avatar.com.co>
##
## All lines beginning with `## DP:' are a description of the patch.
## DP: No description.

@DPATCH@
diff -urNad op-panel-0.26.dfsg~/op_server.pl op-panel-0.26.dfsg/op_server.pl
--- op-panel-0.26.dfsg~/op_server.pl	2006-09-09 07:00:06.000000000 +0000
+++ op-panel-0.26.dfsg/op_server.pl	2006-09-09 07:01:11.000000000 +0000
@@ -308,6 +308,9 @@
     $directorio = $confdir;
 }
 
+open( CONFIG, "<$directorio/op_server.cfg" )
+  or die("Could not open op_server.cfg. Aborting...");
+  
 if ( $logdir ne "" ) {
     open( STDOUT, ">>$logdir/output.log" )
       or die "Can't open output log $logdir/error.log";
@@ -319,7 +322,8 @@
     defined( my $pid = fork ) or die "Can't Fork: $!";
     exit if $pid;
     setsid or die "Can't start a new session: $!";
-    open MYPIDFILE, ">$pidfile";
+    open MYPIDFILE, ">$pidfile"
+       or die "Failed to open PID file $pidfile for writing." ;
     print MYPIDFILE $$;
     close MYPIDFILE;
 
@@ -9100,11 +9104,11 @@
 
 =head1 NAME
 
-op_server.pl - Proxy server for the Asterisk Flash Operator Panel
+op_server - Proxy server for the Asterisk Flash Operator Panel
 
 =head1 SYNOPSIS
 
-op_server.pl [options] 
+op_server [options] 
 
  Options:
    -?, --help
@@ -9125,11 +9129,11 @@
 
 =item B<--pidfile>
 
-Specify the pid file to use when running in daemon mode. Defaults to /var/run/op_panel.pid
+Specify the pid file to use when running in daemon mode. Defaults to /var/run/op_panel.pid. See /etc/init.d/op-panel for Debian defaults.
 
 =item B<--confdir>
 
-Specify where to look for the configuration files. If omited, it will look for them in the same directory where op_server.pl resides
+Specify where to look for the configuration files. If omited, it will look for them in the same directory where op_server resides
 
 =item B<--logdir>
 
@@ -9151,6 +9155,31 @@
 
 =head1 DESCRIPTION
 
-B<This program> will read the given input file(s) and do someting useful with the contents thereof.
+B<This program> is a proxy server for the Flash Operator Panel. It reads configuration files and updates the data to display on the panel.
 
-=cut  
+=head1 FILES
+
+=over 8
+
+=item B</etc/op-panel>
+
+The configuration files of the operator panel daemon reside in that directory
+(may differ on other distributions). Those include:
+
+=item B<op_server.cfg>
+
+The server's configuration file. See remarks in file for documentation.
+
+=item B<op_buttons.cfg>
+
+Defines the layout of the operator panel, and also which phones to track.
+
+=item B</var/log/op-panel/output.log>
+
+The standard output of the daemon, including debugging prints and dumps.
+
+=item B</var/log/op-panel/error.log>
+
+The standard error of the daemon. Should normally be empty.
+
+=cut
