/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/MgmtTypesXml/MgmtCollectInstancesCollectionXml.h"
#include "Doc/DocXml/MgmtTypesXml/MgmtCollectSchemaXml.h"
#include "Doc/DocXml/MgmtTypesXml/MgmtInvokeOperationCollectionXml.h"

#include "Doc/MgmtTypesDoc/CMgmtBatchDoc.h"
#include "Doc/MgmtTypesDoc/CMgmtCollectInstancesCollectionDoc.h"
#include "Doc/MgmtTypesDoc/CMgmtCollectSchemaDoc.h"
#include "Doc/MgmtTypesDoc/CMgmtInvokeOperationCollectionDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/MgmtTypesXml/MgmtBatchXml.h"

using namespace Caf;

void MgmtBatchXml::add(
	const SmartPtrCMgmtBatchDoc mgmtBatchDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtBatchXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(mgmtBatchDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCMgmtCollectSchemaDoc collectSchemaVal =
			mgmtBatchDoc->getCollectSchema();
		if (! collectSchemaVal.IsNull()) {
			const SmartPtrCXmlElement collectSchemaXml =
				thisXml->createAndAddElement("collectSchema");
			MgmtCollectSchemaXml::add(collectSchemaVal, collectSchemaXml);
		}

		const SmartPtrCMgmtCollectInstancesCollectionDoc collectInstancesCollectionVal =
			mgmtBatchDoc->getCollectInstancesCollection();
		if (! collectInstancesCollectionVal.IsNull()) {
			const SmartPtrCXmlElement collectInstancesCollectionXml =
				thisXml->createAndAddElement("collectInstancesCollection");
			MgmtCollectInstancesCollectionXml::add(collectInstancesCollectionVal, collectInstancesCollectionXml);
		}

		const SmartPtrCMgmtInvokeOperationCollectionDoc invokeOperationCollectionVal =
			mgmtBatchDoc->getInvokeOperationCollection();
		if (! invokeOperationCollectionVal.IsNull()) {
			const SmartPtrCXmlElement invokeOperationCollectionXml =
				thisXml->createAndAddElement("invokeOperationCollection");
			MgmtInvokeOperationCollectionXml::add(invokeOperationCollectionVal, invokeOperationCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCMgmtBatchDoc MgmtBatchXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtBatchXml", "parse");

	SmartPtrCMgmtBatchDoc mgmtBatchDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCXmlElement collectSchemaXml =
			thisXml->findOptionalChild("collectSchema");

		SmartPtrCMgmtCollectSchemaDoc collectSchemaVal;
		if (! collectSchemaXml.IsNull()) {
			collectSchemaVal = MgmtCollectSchemaXml::parse(collectSchemaXml);
		}

		const SmartPtrCXmlElement collectInstancesCollectionXml =
			thisXml->findOptionalChild("collectInstancesCollection");

		SmartPtrCMgmtCollectInstancesCollectionDoc collectInstancesCollectionVal;
		if (! collectInstancesCollectionXml.IsNull()) {
			collectInstancesCollectionVal = MgmtCollectInstancesCollectionXml::parse(collectInstancesCollectionXml);
		}

		const SmartPtrCXmlElement invokeOperationCollectionXml =
			thisXml->findOptionalChild("invokeOperationCollection");

		SmartPtrCMgmtInvokeOperationCollectionDoc invokeOperationCollectionVal;
		if (! invokeOperationCollectionXml.IsNull()) {
			invokeOperationCollectionVal = MgmtInvokeOperationCollectionXml::parse(invokeOperationCollectionXml);
		}

		mgmtBatchDoc.CreateInstance();
		mgmtBatchDoc->initialize(
			collectSchemaVal,
			collectInstancesCollectionVal,
			invokeOperationCollectionVal);
	}
	CAF_CM_EXIT;

	return mgmtBatchDoc;
}

