// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppParCurves_MultiPoint_HeaderFile
#define _AppParCurves_MultiPoint_HeaderFile

#ifndef _Handle_MMgt_TShared_HeaderFile
#include <Handle_MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class MMgt_TShared;
class Standard_OutOfRange;
class Standard_DimensionError;
class TColgp_Array1OfPnt;
class TColgp_Array1OfPnt2d;
class gp_Pnt;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes Points composing a MultiPoint. <br>
//!          These points can be 2D or 3D. The user must first give the <br>
//!          3D Points and then the 2D Points. <br>
//!          They are Poles of a Bezier Curve. <br>
//! This class is used either to define data input or <br>
//! results when performing the approximation of several lines in parallel. <br>
class AppParCurves_MultiPoint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! creates an indefinite MultiPoint. <br>
Standard_EXPORT AppParCurves_MultiPoint();

//! constructs a set of Points used to approximate a <br>
//!          Multiline. <br>
//!          These Points can be of 2 or 3 dimensions. <br>
//!          Points will be initialized with SetPoint and SetPoint2d. <br>
//!          NbPoints is the number of 3D Points. <br>
//!          NbPoints2d is the number of 2D Points. <br>
Standard_EXPORT AppParCurves_MultiPoint(const Standard_Integer NbPoints,const Standard_Integer NbPoints2d);

//! creates a MultiPoint only composed of 3D points. <br>
Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt& tabP);

//! creates a MultiPoint only composed of 2D points. <br>
Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt2d& tabP2d);

//! constructs a set of Points used to approximate a <br>
//!          Multiline. <br>
//!          These Points can be of 2 or 3 dimensions. <br>
//!          Points will be initialized with SetPoint and SetPoint2d. <br>
//!          NbPoints is the total number of Points. <br>
Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt& tabP,const TColgp_Array1OfPnt2d& tabP2d);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~AppParCurves_MultiPoint(){Delete();}

//! the 3d Point of range Index of this MultiPoint is <br>
//!          set to <Point>. <br>
//!          An exception is raised if Index < 0 or <br>
//!          Index > number of 3d Points. <br>
Standard_EXPORT   void SetPoint(const Standard_Integer Index,const gp_Pnt& Point) ;

//! returns the 3d Point of range Index. <br>
//!          An exception is raised if Index < 0 or <br>
//!          Index < number of 3d Points. <br>
Standard_EXPORT  const gp_Pnt& Point(const Standard_Integer Index) const;

//! The 2d Point of range Index is set to <Point>. <br>
//!          An exception is raised if Index > 3d Points or <br>
//!          Index > total number of Points. <br>
Standard_EXPORT   void SetPoint2d(const Standard_Integer Index,const gp_Pnt2d& Point) ;

//! returns the 2d Point of range Index. <br>
//!          An exception is raised if index <= number of <br>
//!          3d Points or Index > total number of Points. <br>
Standard_EXPORT  const gp_Pnt2d& Point2d(const Standard_Integer Index) const;
//! returns the dimension of the point of range Index. <br>
//!          An exception is raised if Index <0 or Index > NbCurves. <br>
  Standard_Integer Dimension(const Standard_Integer Index) const;
//! returns the number of points of dimension 3D. <br>
  Standard_Integer NbPoints() const;
//! returns the number of points of dimension 2D. <br>
  Standard_Integer NbPoints2d() const;

//! Applies a transformation to the curve of range <br>
//!          <CuIndex>. <br>
//!          newx = x + dx*oldx <br>
//!          newy = y + dy*oldy    for all points of the curve. <br>
//!          newz = z + dz*oldz <br>
Standard_EXPORT   void Transform(const Standard_Integer CuIndex,const Standard_Real x,const Standard_Real dx,const Standard_Real y,const Standard_Real dy,const Standard_Real z,const Standard_Real dz) ;

//! Applies a transformation to the Curve of range <br>
//!          <CuIndex>. <br>
//!          newx = x + dx*oldx <br>
//!          newy = y + dy*oldy    for all points of the curve. <br>
Standard_EXPORT   void Transform2d(const Standard_Integer CuIndex,const Standard_Real x,const Standard_Real dx,const Standard_Real y,const Standard_Real dy) ;

//! Prints on the stream o information on the current <br>
//!          state of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_MMgt_TShared ttabPoint;
Handle_MMgt_TShared ttabPoint2d;
Standard_Integer nbP;
Standard_Integer nbP2d;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <AppParCurves_MultiPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
