// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_SSIntersectionAttribute_HeaderFile
#define _BOPTools_SSIntersectionAttribute_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Class is a container of three flags used <br>
//!         by intersection algorithm <br>
class BOPTools_SSIntersectionAttribute  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Initializes me by flags <br>
//! <br>
Standard_EXPORT BOPTools_SSIntersectionAttribute(const Standard_Boolean Aproximation = Standard_True,const Standard_Boolean PCurveOnS1 = Standard_True,const Standard_Boolean PCurveOnS2 = Standard_True);


//! Modifier <br>
Standard_EXPORT   void Approximation(const Standard_Boolean theFlag) ;


//! Modifier <br>
Standard_EXPORT   void PCurveOnS1(const Standard_Boolean theFlag) ;


//! Modifier <br>
Standard_EXPORT   void PCurveOnS2(const Standard_Boolean theFlag) ;

//! Selector <br>
  Standard_Boolean Approximation() const;

//! Selector <br>
  Standard_Boolean PCurveOnS1() const;

//! Selector <br>
  Standard_Boolean PCurveOnS2() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myApproximation;
Standard_Boolean myPCurve1;
Standard_Boolean myPCurve2;


};


#include <BOPTools_SSIntersectionAttribute.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
