// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffset_Offset_HeaderFile
#define _BRepOffset_Offset_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _BRepOffset_Status_HeaderFile
#include <BRepOffset_Status.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_JoinType_HeaderFile
#include <GeomAbs_JoinType.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class TopoDS_Face;
class TopTools_DataMapOfShapeShape;
class TopoDS_Edge;
class TopoDS_Vertex;
class TopTools_ListOfShape;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! class for the creation of Offseting. <br>
class BRepOffset_Offset  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepOffset_Offset();


Standard_EXPORT BRepOffset_Offset(const TopoDS_Face& Face,const Standard_Real Offset,const Standard_Boolean OffsetOutside = Standard_True,const GeomAbs_JoinType JoinType = GeomAbs_Arc);

//! This method will be  called when you want to share <br>
//!          the  edges  soon generated  from  an other  face. <br>
//!          e.g. when two faces are  tangents the common  edge <br>
//!          will generate only one edge ( no pipe). <br>
//! <br>
//!          The Map  will be fill  as  follow: <br>
//! <br>
//!          Created(E) = E' <br>
//!          with: E  = an edge of <Face> <br>
//!                E' = the image of E in the offseting  of <br>
//!                     another  face  sharing E  with a <br>
//!                     continuity at least G1 <br>
//! <br>
Standard_EXPORT BRepOffset_Offset(const TopoDS_Face& Face,const Standard_Real Offset,const TopTools_DataMapOfShapeShape& Created,const Standard_Boolean OffsetOutside = Standard_True,const GeomAbs_JoinType JoinType = GeomAbs_Arc);


Standard_EXPORT BRepOffset_Offset(const TopoDS_Edge& Path,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Real Offset,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1);


Standard_EXPORT BRepOffset_Offset(const TopoDS_Edge& Path,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Real Offset,const TopoDS_Edge& FirstEdge,const TopoDS_Edge& LastEdge,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1);

//! Tol and Conti are only used if Polynomial is True <br>
//!          (Used to perfrom the approximation) <br>
Standard_EXPORT BRepOffset_Offset(const TopoDS_Vertex& Vertex,const TopTools_ListOfShape& LEdge,const Standard_Real Offset,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1);


Standard_EXPORT   void Init(const TopoDS_Face& Face,const Standard_Real Offset,const Standard_Boolean OffsetOutside = Standard_True,const GeomAbs_JoinType JoinType = GeomAbs_Arc) ;


Standard_EXPORT   void Init(const TopoDS_Face& Face,const Standard_Real Offset,const TopTools_DataMapOfShapeShape& Created,const Standard_Boolean OffsetOutside = Standard_True,const GeomAbs_JoinType JoinType = GeomAbs_Arc) ;


Standard_EXPORT   void Init(const TopoDS_Edge& Path,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Real Offset,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1) ;


Standard_EXPORT   void Init(const TopoDS_Edge& Path,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Real Offset,const TopoDS_Edge& FirstEdge,const TopoDS_Edge& LastEdge,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1) ;

//! Tol and Conti are only used if Polynomial is True <br>
//!          (Used to perfrom the approximation) <br>
Standard_EXPORT   void Init(const TopoDS_Vertex& Vertex,const TopTools_ListOfShape& LEdge,const Standard_Real Offset,const Standard_Boolean Polynomial = Standard_False,const Standard_Real Tol = 1.0e-4,const GeomAbs_Shape Conti = GeomAbs_C1) ;

//! Only used in Rolling Ball. Pipe on Free Boundary <br>
Standard_EXPORT   void Init(const TopoDS_Edge& Edge,const Standard_Real Offset) ;

 const TopoDS_Shape& InitialShape() const;


Standard_EXPORT  const TopoDS_Face& Face() const;


Standard_EXPORT   TopoDS_Shape Generated(const TopoDS_Shape& Shape) const;


Standard_EXPORT   BRepOffset_Status Status() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
BRepOffset_Status myStatus;
TopoDS_Face myFace;
TopTools_DataMapOfShapeShape myMap;


};


#include <BRepOffset_Offset.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
