// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ChFiDS_FilSpine_HeaderFile
#define _ChFiDS_FilSpine_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ChFiDS_FilSpine_HeaderFile
#include <Handle_ChFiDS_FilSpine.hxx>
#endif

#ifndef _TColgp_SequenceOfXY_HeaderFile
#include <TColgp_SequenceOfXY.hxx>
#endif
#ifndef _Law_Laws_HeaderFile
#include <Law_Laws.hxx>
#endif
#ifndef _ChFiDS_Spine_HeaderFile
#include <ChFiDS_Spine.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Law_Function_HeaderFile
#include <Handle_Law_Function.hxx>
#endif
#ifndef _Handle_Law_Composite_HeaderFile
#include <Handle_Law_Composite.hxx>
#endif
#ifndef _Handle_ChFiDS_HElSpine_HeaderFile
#include <Handle_ChFiDS_HElSpine.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Vertex;
class gp_XY;
class Law_Function;
class Law_Composite;
class ChFiDS_HElSpine;


//! Provides  data specific to  the fillets - <br>
//!          vector or rule  of evolution (C2). <br>
//! <br>
class ChFiDS_FilSpine : public ChFiDS_Spine {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT ChFiDS_FilSpine();


Standard_EXPORT ChFiDS_FilSpine(const Standard_Real Tol);


Standard_EXPORT virtual  void Reset(const Standard_Boolean AllData = Standard_False) ;

//! initializes the constant vector on edge E. <br>
Standard_EXPORT   void SetRadius(const Standard_Real Radius,const TopoDS_Edge& E) ;

//! resets the constant vector  on   edge E. <br>
Standard_EXPORT   void UnSetRadius(const TopoDS_Edge& E) ;

//! initializes the  vector on Vertex V. <br>
Standard_EXPORT   void SetRadius(const Standard_Real Radius,const TopoDS_Vertex& V) ;

//! resets the vector on Vertex V. <br>
Standard_EXPORT   void UnSetRadius(const TopoDS_Vertex& V) ;

//! initializes the vector on the point of parameter W. <br>
Standard_EXPORT   void SetRadius(const gp_XY& UandR,const Standard_Integer IinC) ;

//! initializes the constant vector on all spine. <br>
Standard_EXPORT   void SetRadius(const Standard_Real Radius) ;

//! initializes the rule of evolution on all spine. <br>
Standard_EXPORT   void SetRadius(const Handle(Law_Function)& C,const Standard_Integer IinC) ;

//! returns true if the radius is constant <br>
//!          all along the spine. <br>
Standard_EXPORT   Standard_Boolean IsConstant() const;

//! returns true if the radius is constant <br>
//!          all along the edge E. <br>
Standard_EXPORT   Standard_Boolean IsConstant(const Standard_Integer IE) const;

//! returns the radius if the fillet is constant <br>
//!          all along the spine. <br>
Standard_EXPORT   Standard_Real Radius() const;

//! returns the radius if the fillet is constant <br>
//!          all along the edge E. <br>
Standard_EXPORT   Standard_Real Radius(const Standard_Integer IE) const;

//! returns the radius if the fillet is constant <br>
//!          all along the edge E. <br>
Standard_EXPORT   Standard_Real Radius(const TopoDS_Edge& E) const;


Standard_EXPORT virtual  void AppendElSpine(const Handle(ChFiDS_HElSpine)& Els) ;


Standard_EXPORT   Handle_Law_Composite Law(const Handle(ChFiDS_HElSpine)& Els) const;

//! returns the elementary law <br>
Standard_EXPORT   Handle_Law_Function& ChangeLaw(const TopoDS_Edge& E) ;

//! returns the maximum radius if the fillet is non-constant <br>
Standard_EXPORT   Standard_Real MaxRadFromSeqAndLaws() const;
//Standard_EXPORT ~ChFiDS_FilSpine();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Handle_Law_Composite ComputeLaw(const Handle(ChFiDS_HElSpine)& Els) ;


Standard_EXPORT   void AppendLaw(const Handle(ChFiDS_HElSpine)& Els) ;


 // Fields PRIVATE
 //
TColgp_SequenceOfXY parandrad;
Law_Laws laws;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
