// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Image_HeaderFile
#define _Image_HeaderFile

#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
class Image_Image;
class Image_PixelInterpolation;
class gp_GTrsf2d;
class gp_Trsf;
class Image_Image;
class Image_PixelInterpolation;
class Image_AveragePixelInterpolation;
class Image_BalancedPixelInterpolation;
class Image_PlanarPixelInterpolation;
class Image_BilinearPixelInterpolation;
class Image_GPixelField;
class Image_GImage;
class Image_PixelRow;
class Image_PixelField;
class Image_DColorImage;
class Image_DIndexedImage;
class Image_PseudoColorImage;
class Image_ColorImage;
class Image_Convertor;
class Image_ColorPixelMapHasher;
class Image_ColorPixelDataMap;
class Image_IndexPixelMapHasher;
class Image_LookupTable;
class Image_PixelRowOfDColorImage;
class Image_PixelFieldOfDColorImage;
class Image_PixelRowOfDIndexedImage;
class Image_PixelFieldOfDIndexedImage;
class Image_DataMapNodeOfColorPixelDataMap;
class Image_DataMapIteratorOfColorPixelDataMap;
class Image_DataMapNodeOfLookupTable;
class Image_DataMapIteratorOfLookupTable;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The package Image provide PseudoColorImage and ColorImage <br>
//!		definition and a set of key functions from the fields <br>
//!		of image. <br>
class Image  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Zoom an Image with a specific PixelInterpolation method. <br>
Standard_EXPORT static  void Zoom(const Handle(Image_Image)& aImage,const Image_PixelInterpolation& aInterpolation,const Standard_Real aCoefX,const Standard_Real aCoefY) ;

//! Zoom an Image with the default PixelInterpolation method. <br>
Standard_EXPORT static  void Zoom(const Handle(Image_Image)& aImage,const Standard_Real aCoefX,const Standard_Real aCoefY) ;

//! Rotate an Image with a specific PixelInterpolation method. <br>
Standard_EXPORT static  void Rotate(const Handle(Image_Image)& aImage,const Image_PixelInterpolation& aInterpolation,const Quantity_PlaneAngle aAngle) ;

//! Rotate an Image with the default PixelInterpolation method. <br>
Standard_EXPORT static  void Rotate(const Handle(Image_Image)& aImage,const Quantity_PlaneAngle aAngle) ;

//! Translate an Image with a specific PixelInterpolation <br>
//!		method. <br>
Standard_EXPORT static  void Translate(const Handle(Image_Image)& aImage,const Image_PixelInterpolation& aInterpolation,const Standard_Real DX,const Standard_Real DY) ;

//! Translate an Image with the default PixelInterpolation <br>
//!		method. <br>
Standard_EXPORT static  void Translate(const Handle(Image_Image)& aImage,const Standard_Real DX,const Standard_Real DY) ;

//! General transformation of an Image with a specific <br>
//!		PixelInterpolation method. <br>
//!	Warning: <br>
//!  		Raises an exception if the matrix of the transformation <br>
//!  		is not inversible. <br>
Standard_EXPORT static  void Affine(const Handle(Image_Image)& aImage,const Image_PixelInterpolation& aInterpolation,const gp_GTrsf2d& Trsf) ;

//! General transformation of an Image with the default <br>
//!		PixelInterpolation method. <br>
//!	Warning: <br>
//!  		Raises an exception if the matrix of the transformation <br>
//!  		is not inversible. <br>
Standard_EXPORT static  void Affine(const Handle(Image_Image)& aImage,const gp_GTrsf2d& Trsf) ;

//! General transformation of an Image with a specific <br>
//!		PixelInterpolation method. <br>
//!	Warning: <br>
//!  		Raises an exception if the matrix of the transformation <br>
//!  		is not inversible. <br>
Standard_EXPORT static  void Affine(const Handle(Image_Image)& aImage,const Image_PixelInterpolation& aInterpolation,const gp_Trsf& Trsf) ;

//! General transformation of an Image with the default <br>
//!		PixelInterpolation method. <br>
//!	Warning: <br>
//!  		Raises an exception if the matrix of the transformation <br>
//!  		is not inversible. <br>
Standard_EXPORT static  void Affine(const Handle(Image_Image)& aImage,const gp_Trsf& Trsf) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Image_Image;
friend class Image_PixelInterpolation;
friend class Image_AveragePixelInterpolation;
friend class Image_BalancedPixelInterpolation;
friend class Image_PlanarPixelInterpolation;
friend class Image_BilinearPixelInterpolation;
friend class Image_GPixelField;
friend class Image_GImage;
friend class Image_PixelRow;
friend class Image_PixelField;
friend class Image_DColorImage;
friend class Image_DIndexedImage;
friend class Image_PseudoColorImage;
friend class Image_ColorImage;
friend class Image_Convertor;
friend class Image_ColorPixelMapHasher;
friend class Image_ColorPixelDataMap;
friend class Image_IndexPixelMapHasher;
friend class Image_LookupTable;
friend class Image_PixelRowOfDColorImage;
friend class Image_PixelFieldOfDColorImage;
friend class Image_PixelRowOfDIndexedImage;
friend class Image_PixelFieldOfDIndexedImage;
friend class Image_DataMapNodeOfColorPixelDataMap;
friend class Image_DataMapIteratorOfColorPixelDataMap;
friend class Image_DataMapNodeOfLookupTable;
friend class Image_DataMapIteratorOfLookupTable;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
