// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntAna2d_Conic_HeaderFile
#define _IntAna2d_Conic_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Circ2d;
class gp_Lin2d;
class gp_Parab2d;
class gp_Hypr2d;
class gp_Elips2d;
class gp_XY;
class gp_Ax2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Definition of a conic by its implicit quadaratic equation: <br>
//!          A.X**2 + B.Y**2 + 2.C.X*Y + 2.D.X + 2.E.Y + F = 0. <br>
class IntAna2d_Conic  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntAna2d_Conic(const gp_Circ2d& C);


Standard_EXPORT IntAna2d_Conic(const gp_Lin2d& C);


Standard_EXPORT IntAna2d_Conic(const gp_Parab2d& C);


Standard_EXPORT IntAna2d_Conic(const gp_Hypr2d& C);


Standard_EXPORT IntAna2d_Conic(const gp_Elips2d& C);

//! value of the function F at the point X,Y. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Real X,const Standard_Real Y) const;

//! returns the value of the gradient of F at the point X,Y. <br>
Standard_EXPORT   gp_XY Grad(const Standard_Real X,const Standard_Real Y) const;

//! Returns the value of the function and its gradient at <br>
//!          the point X,Y. <br>
Standard_EXPORT   void ValAndGrad(const Standard_Real X,const Standard_Real Y,Standard_Real& Val,gp_XY& Grd) const;

//! returns the coefficients of the polynomial equation <br>
//!          wich defines the conic: <br>
//!          A.X**2 + B.Y**2 + 2.C.X*Y + 2.D.X + 2.E.Y + F = 0. <br>
Standard_EXPORT   void Coefficients(Standard_Real& A,Standard_Real& B,Standard_Real& C,Standard_Real& D,Standard_Real& E,Standard_Real& F) const;

//! Returns the coefficients of the polynomial equation <br>
//!          ( written in the natural coordinates system ) <br>
//!          A x x + B y y + 2 C x y + 2 D x + 2 E y + F <br>
//!          in the local coordinates system defined by Axis <br>
Standard_EXPORT   void NewCoefficients(Standard_Real& A,Standard_Real& B,Standard_Real& C,Standard_Real& D,Standard_Real& E,Standard_Real& F,const gp_Ax2d& Axis) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real a;
Standard_Real b;
Standard_Real c;
Standard_Real d;
Standard_Real e;
Standard_Real f;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
