// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepData_StepDumper_HeaderFile
#define _StepData_StepDumper_HeaderFile

#ifndef _Handle_StepData_StepModel_HeaderFile
#include <Handle_StepData_StepModel.hxx>
#endif
#ifndef _Interface_GeneralLib_HeaderFile
#include <Interface_GeneralLib.hxx>
#endif
#ifndef _StepData_WriterLib_HeaderFile
#include <StepData_WriterLib.hxx>
#endif
#ifndef _StepData_StepWriter_HeaderFile
#include <StepData_StepWriter.hxx>
#endif
#ifndef _Handle_StepData_Protocol_HeaderFile
#include <Handle_StepData_Protocol.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class StepData_StepModel;
class Interface_InterfaceMismatch;
class StepData_Protocol;
class StepData_StepWriter;
class Message_Messenger;
class Standard_Transient;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides a way to dump entities processed through STEP, with <br>
//!           these features : <br>
//!           - same form as for writing a STEP File (because it is clear <br>
//!             and compact enough, even if the names of the fields do not <br>
//!             appear) : thus, no additionnal resource is required <br>
//!           - possibility to look for an entity itself (only its Type or <br>
//!             with its content), an entity and it shared items (one level) <br>
//!             or all the entities its refers to, directly or recursively. <br>
class StepData_StepDumper  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a StepDumper, able to work on a given StepModel <br>
//!           (which defines the total scope for dumping entities) and <br>
//!           a given Protocol from Step (which defines the authorized <br>
//!           types to be dumped) <br>
//!           <mode> commands what is to be displayed (number or label) <br>
//!           0 for number (and corresponding labels  are displayed apart) <br>
//!           1 for label  (and corresponding numbers are displayed apart) <br>
//!           2 for label without anymore <br>
Standard_EXPORT StepData_StepDumper(const Handle(StepData_StepModel)& amodel,const Handle(StepData_Protocol)& protocol,const Standard_Integer mode = 0);

//! Gives an access to the tool which is used to work : this allow <br>
//!           to acts on some parameters : Floating Format, Scopes ... <br>
Standard_EXPORT   StepData_StepWriter& StepWriter() ;

//! Dumps a Entity on an Messenger. Returns True if <br>
//!           sucess, False, if the entity to dump has not been recognized <br>
//!           by the Protocol. <level> can have one of these values : <br>
//!           - 0 : prints the TYPE only, as known in STEP Files (StepType) <br>
//!             If <ent> has not been regognized by the Protocol, or if its <br>
//!             type is Complex, the StepType is replaced by the display of <br>
//!             the cdl type. Complex Type are well processed by level 1. <br>
//!           - 1 : dumps the entity, completely (whatever it has simple or <br>
//!             complex type) but alone. <br>
//!           - 2 : dumps the entity completely, plus the item its refers to <br>
//!                 at first level (a header message designates the starting <br>
//!                 entity of the dump) <Lists Shared and Implied> <br>
//!           - 3 : dumps the entity and its refered items at any levels <br>
//! <br>
//!           For levels 1,2,3, the numbers displayed (form #nnn) are the <br>
//!           numbers of the corresponding entities in the Model <br>
Standard_EXPORT   Standard_Boolean Dump(const Handle(Message_Messenger)& S,const Handle(Standard_Transient)& ent,const Standard_Integer level) ;

//! Works as Dump with a Transient, but directly takes the <br>
//!           entity designated by its number in the Model <br>
//!           Returns False, also if <num> is out of range <br>
Standard_EXPORT   Standard_Boolean Dump(const Handle(Message_Messenger)& S,const Standard_Integer num,const Standard_Integer level) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_StepData_StepModel themodel;
Interface_GeneralLib theslib;
StepData_WriterLib thewlib;
StepData_StepWriter thewriter;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
