// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StlAPI_HeaderFile
#define _StlAPI_HeaderFile

#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;
class StlAPI_Writer;
class StlAPI_Reader;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Offers the API for STL data manipulation. <br>
//! <br>
class StlAPI  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Convert and write shape to STL format. <br>
//!         file is written in binary if aAsciiMode is False <br>
//!         otherwise it is written in Ascii (by default) <br>
Standard_EXPORT static  void Write(const TopoDS_Shape& aShape,const Standard_CString aFile,const Standard_Boolean aAsciiMode = Standard_True) ;

//! Create a shape from a STL format. <br>
Standard_EXPORT static  void Read(TopoDS_Shape& aShape,const Standard_CString aFile) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class StlAPI_Writer;
friend class StlAPI_Reader;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
