// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TFunction_IFunction_HeaderFile
#define _TFunction_IFunction_HeaderFile

#ifndef _TDF_Label_HeaderFile
#include <TDF_Label.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TFunction_ExecutionStatus_HeaderFile
#include <TFunction_ExecutionStatus.hxx>
#endif
#ifndef _Handle_TFunction_Driver_HeaderFile
#include <Handle_TFunction_Driver.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TFunction_GraphNode_HeaderFile
#include <Handle_TFunction_GraphNode.hxx>
#endif
class TDF_Label;
class Standard_GUID;
class TDF_LabelList;
class TFunction_DoubleMapOfIntegerLabel;
class TFunction_Logbook;
class TFunction_Driver;
class TFunction_GraphNode;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Interface class for usage of Function Mechanism <br>
class TFunction_IFunction  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Sets a new function attached to a label <L> with <ID>. <br>
//!          It creates a new TFunction_Function attribute initialized by the <ID>, <br>
//!          a new TFunction_GraphNode with an empty list of dependencies and <br>
//!          the status equal to TFunction_ES_WrongDefinition. <br>
//!          It registers the function in the scope of functions for this document. <br>
Standard_EXPORT static  Standard_Boolean NewFunction(const TDF_Label& L,const Standard_GUID& ID) ;

//! Deletes a function attached to a label <L>. <br>
//!          It deletes a TFunction_Function attribute and a TFunction_GraphNode. <br>
//!          It deletes the functions from the scope of function of this document. <br>
Standard_EXPORT static  Standard_Boolean DeleteFunction(const TDF_Label& L) ;

//! Updates dependencies for all functions of the scope. <br>
//!          It returns false in case of an error. <br>//! An empty constructor. <br>
Standard_EXPORT static  Standard_Boolean UpdateDependencies(const TDF_Label& Access) ;


Standard_EXPORT TFunction_IFunction();

//! A constructor. <br>
//!          Initializes the interface by the label of function. <br>
Standard_EXPORT TFunction_IFunction(const TDF_Label& L);

//! Initializes the interface by the label of function. <br>
Standard_EXPORT   void Init(const TDF_Label& L) ;

//! Returns a label of the function. <br>
Standard_EXPORT  const TDF_Label& Label() const;

//! Updates the dependencies of this function only. <br>
Standard_EXPORT   Standard_Boolean UpdateDependencies() const;

//! The method fills-in the list by labels, <br>
//!          where the arguments of the function are located. <br>
Standard_EXPORT   void Arguments(TDF_LabelList& args) const;

//! The method fills-in the list by labels, <br>
//!          where the results of the function are located. <br>
Standard_EXPORT   void Results(TDF_LabelList& res) const;

//! Returns a list of previous functions. <br>
Standard_EXPORT   void GetPrevious(TDF_LabelList& prev) const;

//! Returns a list of next functions. <br>
Standard_EXPORT   void GetNext(TDF_LabelList& prev) const;

//! Returns the execution status of the function. <br>
Standard_EXPORT   TFunction_ExecutionStatus GetStatus() const;

//! Defines an execution status for a function. <br>
Standard_EXPORT   void SetStatus(const TFunction_ExecutionStatus status) const;

//! Returns the scope of all functions. <br>
Standard_EXPORT  const TFunction_DoubleMapOfIntegerLabel& GetAllFunctions() const;

//! Returns the Logbook - keeper of modifications. <br>
Standard_EXPORT   TFunction_Logbook& GetLogbook() const;

//! Returns a driver of the function. <br>
Standard_EXPORT   Handle_TFunction_Driver GetDriver(const Standard_Integer thread = 0) const;

//! Returns a graph node of the function. <br>
Standard_EXPORT   Handle_TFunction_GraphNode GetGraphNode() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDF_Label myLabel;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
