// File:	StepToGeom_MakeVectorWithMagnitude2d.cxx
// Created:	Wed Aug  4 11:45:12 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 23.10.2001. CTS23496: Vector is not created if direction have not been succesfully created (StepToGeom_MakeVectorWithMagnitude2d(...) function)

#include <StepToGeom_MakeVectorWithMagnitude2d.ixx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_Direction.hxx>
#include <StepToGeom_MakeDirection2d.hxx>
#include <Geom2d_Direction.hxx>
#include <gp_Dir2d.hxx>
#include <gp_Vec2d.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un VectorWithMagnitude de Geom2d a partir d' un Vector de Step
//=============================================================================

StepToGeom_MakeVectorWithMagnitude2d::StepToGeom_MakeVectorWithMagnitude2d
  ( const Handle(StepGeom_Vector)& V)
{
  Standard_Real M;
  Handle(StepGeom_Direction) D;
  Handle(Geom2d_Direction)       D1;
  gp_Dir2d                       D2;
  gp_Vec2d                       V1;

  D  = V->Orientation();
  StepToGeom_MakeDirection2d MkDir2d(D);
  // sln 23.10.2001. CTS23496: Vector is not created if direction have not been succesfully created (StepToGeom_MakeVectorWithMagnitude2d(...) function)
  if(!MkDir2d.IsDone()) {
    done = Standard_False;
    return;
  }
  D1 = MkDir2d.Value();
  D2 = D1->Dir2d();
  V1 = gp_Vec2d(D2);
  M  = V->Magnitude();
  V1 = V1*M;
  theVectorWithMagnitude = new Geom2d_VectorWithMagnitude(V1);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_VectorWithMagnitude) &
      StepToGeom_MakeVectorWithMagnitude2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theVectorWithMagnitude;
}
