// AISSelectDoc.cpp : implementation of the CAISSelectDoc class
//

#include "stdafx.h"
#include "AISSelectApp.h"

#include "AISSelectDoc.h"
#include <BoxRadius.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAISSelectDoc

IMPLEMENT_DYNCREATE(CAISSelectDoc, CDocument)

BEGIN_MESSAGE_MAP(CAISSelectDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CAISSelectDoc)
	ON_COMMAND(ID_BOX, OnBox)
	ON_COMMAND(ID_USERCYLINDER, OnUsercylinder)
	ON_COMMAND(ID_FACES, OnFaces)
	ON_COMMAND(ID_EDGES, OnEdges)
	ON_COMMAND(ID_VERTICES, OnVertices)
	ON_COMMAND(ID_NEUTRAL, OnNeutral)
	ON_COMMAND(ID_USERCYLINDER_CHANGEFACECOLOR, OnUsercylinderChangefacecolor)
	ON_COMMAND(ID_FILLET3D, OnFillet3d)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAISSelectDoc construction/destruction

CAISSelectDoc::CAISSelectDoc()
{
	myState = -1;
}

CAISSelectDoc::~CAISSelectDoc()
{
}


/////////////////////////////////////////////////////////////////////////////
// CAISSelectDoc diagnostics

#ifdef _DEBUG
void CAISSelectDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAISSelectDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAISSelectDoc commands



//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CAISSelectDoc::InputEvent(const Standard_Integer  x     ,
			                   const Standard_Integer  y     ,
                               const Handle(V3d_View)& aView ) 
{
	Quantity_Color CSFColor ;
 	COLORREF MSColor ;
	myAISContext->Select(); 
// Change the color of a selected face in a user cylinder
 	if (myState == FACE_COLOR) {
 		myAISContext->InitSelected();
		if (myAISContext->MoreSelected()) {
			//Handle_AIS_InteractiveObject Current = myAISContext->Current() ;
			Handle_AIS_InteractiveObject Current = myAISContext->SelectedInteractive() ;
  			if ( Current->HasColor () ) {
        		CSFColor = myAISContext->Color(Current);
		       	MSColor = RGB (CSFColor.Red()*255.,CSFColor.Green()*255.,CSFColor.Blue()*255.);
  			}
  			else {
  				MSColor = RGB ( 255,255,255 ) ;
  			}
    
  			CColorDialog dlgColor(MSColor);
  			if (dlgColor.DoModal() == IDOK) {
  				MSColor = dlgColor.GetColor();
  				CSFColor = Quantity_Color (GetRValue(MSColor)/255.,
  										   GetGValue(MSColor)/255.,
  										   GetBValue(MSColor)/255.,Quantity_TOC_RGB); 
  				TopoDS_Shape S = myAISContext->SelectedShape();
  				Handle(Geom_Surface) Surface = BRep_Tool::Surface(TopoDS::Face(S));
  				if (Surface->IsKind(STANDARD_TYPE(Geom_Plane)))
  					//Handle(User_Cylinder)::DownCast(myAISContext->Current())->SetPlanarFaceColor(CSFColor.Name());
					Handle(User_Cylinder)::DownCast(myAISContext->SelectedInteractive())->SetPlanarFaceColor(CSFColor.Name());
  				else
  					//Handle(User_Cylinder)::DownCast(myAISContext->Current())->SetCylindricalFaceColor(CSFColor.Name());
					Handle(User_Cylinder)::DownCast(myAISContext->SelectedInteractive())->SetCylindricalFaceColor(CSFColor.Name());
  				//myAISContext->Redisplay(myAISContext->Current());
				myAISContext->Redisplay(myAISContext->SelectedInteractive());
  				myState = -1;
  				myAISContext->CloseLocalContext();
  			}
  		}
  TCollection_AsciiString Message ("\
  TopoDS_Shape S = myAISContext->SelectedShape();  \n\
  \n\
  Handle(Geom_Surface) Surface = BRep_Tool::Surface(TopoDS::Face(S));  \n\
  \n\
  if (Surface->IsKind(STANDARD_TYPE(Geom_Plane)))  \n\
  	Handle(User_Cylinder)::DownCast(myAISContext->Current())->SetPlanarFaceColor(CSFColor.Name());  \n\
  else  \n\
  	Handle(User_Cylinder)::DownCast(myAISContext->Current())->SetCylindricalFaceColor(CSFColor.Name());  \n\
  \n\
  myAISContext->Redisplay(myAISContext->Current());  \n\
  \n\
  myAISContext->CloseLocalContext();  \n\
  \n\
  \n\
  NOTE: a User_Cylinder is an object defined by the user.  \n\
  The User_Cylinder class inherit from the AIS_InteractiveObject   \n\
  Cascade class, it's use is the same as an AIS_InteractiveObject.   \n\
  Methods SetPlanarFaceColor and SetCylindricalFaceColor are also  \n\
  defined in the User_Cylinder class.   \n\
  \n");
  
  	CString text(Message.ToCString());
  	myCResultDialog.SetTitle(CString("Change face color"));
  	myCResultDialog.SetText(text);
  	SetTitle(CString("Change face color"));
  
  	}
  
  }


//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void  CAISSelectDoc::Popup(const Standard_Integer  x,
							   const Standard_Integer  y ,
                               const Handle(V3d_View)& aView   ) 
{
	Standard_Integer PopupMenuNumber=0;
	myAISContext->InitCurrent();
	if (myAISContext->MoreCurrent()) {
		if (myAISContext->Current()->IsKind(STANDARD_TYPE(User_Cylinder)))
			PopupMenuNumber = 1;
		else 
			PopupMenuNumber = 2;
	}

  CMenu menu;
  VERIFY(menu.LoadMenu(IDR_Popup3D));
  CMenu* pPopup = menu.GetSubMenu(PopupMenuNumber);
  ASSERT(pPopup != NULL);
  if (PopupMenuNumber == 2) // more than 1 object.
  {
    bool OneOrMoreInShading = false;
	for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),1)) OneOrMoreInShading=true;
	if(!OneOrMoreInShading)
   	pPopup->EnableMenuItem(5, MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
   }

 
  POINT winCoord = { x , y };
  Handle(WNT_Window) aWNTWindow=
  Handle(WNT_Window)::DownCast(aView->Window());
  ClientToScreen ( (HWND)(aWNTWindow->HWindow()),&winCoord);
  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON , winCoord.x, winCoord.y , 
                         AfxGetMainWnd());

}

// Create a box and display it
void CAISSelectDoc::OnBox() 
{
	myAISContext->CloseAllContexts();
	BRepPrimAPI_MakeBox B(gp_Pnt(-400.,-400.,-100.),200.,150.,100.);
	Handle(AIS_Shape) aBox = new AIS_Shape(B.Shape());
	myAISContext->SetMaterial (aBox, Graphic3d_NOM_GOLD, Standard_False);
	myAISContext->SetDisplayMode (aBox, 1, Standard_False);
	myAISContext->Display(aBox);

TCollection_AsciiString Message ("\
BRepAPI_MakeBox B(gp_Pnt(-400.,-400.,-100.),200.,150.,100.);  \n\
\n\
Handle(AIS_Shape) aBox = new AIS_Shape(B.Shape());  \n\
\n\
myAISContext->Display(aBox);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a box"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a box"));
}

//Create and display a cylinder with user defined presentation
void CAISSelectDoc::OnUsercylinder() 
{
	myAISContext->CloseAllContexts();
	Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);
	myAISContext->SetDisplayMode(aCyl,1);
	myAISContext->Display(aCyl);

TCollection_AsciiString Message ("\
Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);  \n\
\n\
myAISContext->SetDisplayMode(aCyl,1);  \n\
\n\
myAISContext->Display(aCyl); \n\
\n\
NOTE: a User_Cylinder is an object defined by the user.  \n\
The User_Cylinder class inherit from the AIS_InteractiveObject   \n\
Cascade class, it's use is the same as an AIS_InteractiveObject.   \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a cylinder"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a cylinder"));
}

//Set faces selection mode
void CAISSelectDoc::OnFaces() 
{
	myAISContext->CloseAllContexts();
	myAISContext->OpenLocalContext();
	myAISContext->ActivateStandardMode(TopAbs_FACE);

TCollection_AsciiString Message ("\
myAISContext->OpenLocalContext();  \n\
\n\
myAISContext->ActivateStandardMode(TopAbs_FACE);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Standard mode: TopAbs_FACE"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Standard mode: TopAbs_FACE"));
}

//Set edges selection mode
void CAISSelectDoc::OnEdges() 
{
	myAISContext->CloseAllContexts();
	myAISContext->OpenLocalContext();
	myAISContext->ActivateStandardMode(TopAbs_EDGE);	

TCollection_AsciiString Message ("\
myAISContext->OpenLocalContext();  \n\
\n\
myAISContext->ActivateStandardMode(TopAbs_EDGE);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Standard mode: TopAbs_EDGE"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Standard mode: TopAbs_EDGE"));
}

// Set vertices selection mode
void CAISSelectDoc::OnVertices() 
{
	myAISContext->CloseAllContexts();
	myAISContext->OpenLocalContext();
	myAISContext->ActivateStandardMode(TopAbs_VERTEX);	

TCollection_AsciiString Message ("\
myAISContext->OpenLocalContext();  \n\
\n\
myAISContext->ActivateStandardMode(TopAbs_VERTEX);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Standard mode: TopAbs_VERTEX"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Standard mode: TopAbs_VERTEX"));
}

//Neutral selection mode
void CAISSelectDoc::OnNeutral() 
{
	myAISContext->CloseAllContexts();	

TCollection_AsciiString Message ("\
myAISContext->CloseAllContexts();  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Standard mode: Neutral"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Standard mode: Neutral"));
}

// Change the color of faces on a user cylinder
void CAISSelectDoc::OnUsercylinderChangefacecolor() 
{
	myAISContext->OpenLocalContext();
	myAISContext->Activate(myAISContext->Current(),4);
	myState = FACE_COLOR;
// see the following of treatment in inputevent
}

// Make 3d fillets on solids
// It is necessary to activate the edges selection mode and select edges on an object
// before running this function
void CAISSelectDoc::OnFillet3d() 
{
    if(	!myAISContext->HasOpenedContext())
    {
        AfxMessageBox("It is necessary to activate the edges selection mode\n\
and select edges on an object before \nrunning this function");
        return;
    }
    
	myAISContext->InitSelected();
	if (myAISContext->MoreSelected()) {	
			Handle(AIS_Shape) S = Handle(AIS_Shape)::DownCast(myAISContext->SelectedInteractive());
			
			if (S.IsNull()){
				AfxMessageBox("It is necessary to activate the edges selection mode\n\
and select edges on an object before \nrunning this function");
				return;
			}
		
			TopoDS_Shape Sh=S->Shape();
	
			BRepFilletAPI_MakeFillet aFillet(Sh);
				
			for (myAISContext->InitSelected(); myAISContext->MoreSelected(); myAISContext->NextSelected())								
			{
                TopoDS_Edge anEdge;
				try {
					anEdge=TopoDS::Edge(myAISContext->SelectedShape());
				}
	            catch(Standard_Failure)
		        {
				}
				
				if (anEdge.IsNull())
                {
                    AfxMessageBox("It is necessary to activate the edges selection mode\n\
and select edges on an object before \nrunning this function");
                    return;
                }
			}

			BoxRadius dlg(NULL,10.);
			if (dlg.DoModal() == IDOK){
				for (myAISContext->InitSelected(); myAISContext->MoreSelected(); myAISContext->NextSelected()){
                TopoDS_Edge anEdge = TopoDS::Edge(myAISContext->SelectedShape());
				aFillet.Add(dlg.m_radius,anEdge);
				}
			}
			else return;

            TopoDS_Shape aNewShape;
//            if(!aFillet.IsDone())
            try{
               aNewShape = aFillet.Shape();
            }
            catch(Standard_Failure)
            {
               AfxMessageBox("Error During Fillet computation");
               return;
            }
            S ->Set(aNewShape);
			myAISContext->Redisplay(S);						
			
	}
TCollection_AsciiString Message ("\
Handle(AIS_Shape) S = Handle(AIS_Shape)::DownCast(myAISContext->Interactive());  \n\
\n\
BRepAPI_MakeFillet aFillet(S->Shape());   \n\
\n\
TopoDS_Edge anEdge=TopoDS::Edge(myAISContext->SelectedShape());  \n\
\n\
aFillet.Add(dlg.m_radius,anEdge);  \n\
\n\
TopoDS_Shape aNewShape = aFillet.Shape();  \n\
\n\
S ->Set(aNewShape);  \n\
\n\
myAISContext->Redisplay(S);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Make a fillet"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Make a fillet"));
}

